/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.DocumentApp;
import com.collabnet.cubit.api.CubitConnector;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class CNFormFieldValidator {
    private static Logger log = Logger.getLogger("CNFormFieldValidator");

    public static String checkInterpretedString(String str) {
        Pattern envPat = Pattern.compile("\\$\\{(\\w*)\\}");
        Matcher matcher = envPat.matcher(str);
        HashSet<String> envVars = new HashSet<String>(9);
        envVars.add("BUILD_NUMBER");
        envVars.add("BUILD_ID");
        envVars.add("JOB_NAME");
        envVars.add("BUILD_TAG");
        envVars.add("EXECUTOR_NUMBER");
        envVars.add("JAVA_HOME");
        envVars.add("WORKSPACE");
        envVars.add("HUDSON_URL");
        envVars.add("SVN_REVISION");
        envVars.add("CVS_BRANCH");
        String message = null;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (envVars.contains(key)) continue;
            if (message == null) {
                message = "Environmental Variables not found: " + key;
                continue;
            }
            message = message + ", " + key;
        }
        return message;
    }

    public static boolean checkUrl(String url) {
        HttpClient client = new HttpClient();
        try {
            GetMethod get = new GetMethod(url);
            int status = client.executeMethod((HttpMethod)get);
            return status == 200;
        }
        catch (IOException e) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static FormValidation requiredCheck(String value, String name) {
        value = StringUtils.strip((String)value);
        if (CommonUtil.unset((String)name)) {
            name = "above value";
        }
        if (CommonUtil.unset((String)value)) {
            return FormValidation.error((String)("The " + name + " is required."));
        }
        return FormValidation.ok();
    }

    public static FormValidation interpretedCheck(String str, String name, boolean isRequired) {
        if (CommonUtil.unset((String)str)) {
            if (!isRequired) {
                return FormValidation.ok();
            }
            if (CommonUtil.unset((String)name)) {
                name = "above value";
            }
            return FormValidation.error((String)("The " + name + " is required."));
        }
        String errmsg = CNFormFieldValidator.checkInterpretedString((String)str);
        if (errmsg != null) {
            return FormValidation.error((String)errmsg);
        }
        return FormValidation.ok();
    }

    public static FormValidation unrequiredInterpretedCheck(String str, String name) {
        return CNFormFieldValidator.interpretedCheck((String)str, (String)name, (boolean)false);
    }

    public static FormValidation requiredInterpretedCheck(String str, String name) {
        return CNFormFieldValidator.interpretedCheck((String)str, (String)name, (boolean)true);
    }

    public static FormValidation hostUrlCheck(String hostUrl) {
        if (CommonUtil.unset((String)hostUrl)) {
            return FormValidation.error((String)"The Host URL is required.");
        }
        Protocol acceptAllSsl = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)acceptAllSsl);
        if (!CNFormFieldValidator.checkUrl((String)hostUrl)) {
            return FormValidation.error((String)"Invalid Host URL.");
        }
        return FormValidation.ok();
    }

    public static FormValidation soapUrlCheck(String collabNetUrl) {
        if (CommonUtil.unset((String)collabNetUrl)) {
            return FormValidation.error((String)"The CollabNet TeamForge URL is required.");
        }
        if (!CNFormFieldValidator.checkSoapUrl((String)collabNetUrl)) {
            return FormValidation.error((String)"Invalid CollabNet TeamForge URL.");
        }
        return FormValidation.ok();
    }

    private static boolean checkSoapUrl(String collabNetUrl) {
        String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
        return CNFormFieldValidator.checkUrl((String)soapURL);
    }

    public static FormValidation loginCheck(StaplerRequest request) {
        String password = request.getParameter("password");
        if (CommonUtil.unset((String)password)) {
            return FormValidation.error((String)"The password is required.");
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        if (cna == null) {
            return FormValidation.warning((String)"Login fails with this CollabNet URL/username/password combination.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation projectCheck(StaplerRequest request) {
        String username = CNHudsonUtil.getUsername((StaplerRequest)request);
        String project = request.getParameter("project");
        if (CommonUtil.unset((String)project)) {
            return FormValidation.error((String)"The project is required.");
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        if (cna != null) {
            if (CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project) == null) {
                CNHudsonUtil.logoff((CollabNetApp)cna);
                return FormValidation.warning((String)("This project cannot be found, or user " + username + " does not have permission " + "to access it."));
            }
            CNHudsonUtil.logoff((CollabNetApp)cna);
        }
        return FormValidation.ok();
    }

    public static FormValidation documentPathCheck(StaplerRequest request) throws IOException {
        DocumentApp da;
        String missing;
        String project = request.getParameter("project");
        String path = request.getParameter("path");
        path = path.replaceAll("/+", "/");
        if (CommonUtil.unset((String)(path = CommonUtil.stripSlashes((String)path)))) {
            return FormValidation.error((String)"The path is required.");
        }
        String errmsg = null;
        errmsg = CNFormFieldValidator.checkInterpretedString((String)path);
        if (errmsg != null) {
            return FormValidation.error((String)errmsg);
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (projectId != null && (missing = (da = new DocumentApp(cna)).verifyPath(projectId, path)) != null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)("Folder '" + missing + "' could not be " + "found in path '" + path + "'.  It (and " + "any subfolders) will " + "be created dynamically."));
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation packageCheck(StaplerRequest request) {
        String packageId;
        String rpackage = request.getParameter("package");
        String project = request.getParameter("project");
        if (CommonUtil.unset((String)rpackage)) {
            return FormValidation.error((String)"The package is required.");
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (projectId != null && (packageId = CNHudsonUtil.getPackageId((CollabNetApp)cna, (String)rpackage, (String)projectId)) == null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)"Package could not be found.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation releaseCheck(StaplerRequest request) {
        String releaseId;
        String projectId;
        String release = request.getParameter("release");
        String rpackage = request.getParameter("package");
        String project = request.getParameter("project");
        String required = request.getParameter("required");
        if (CommonUtil.unset((String)release)) {
            if (required.toLowerCase().equals("true")) {
                return FormValidation.error((String)"The release is required.");
            }
            return FormValidation.ok();
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        String packageId = CNHudsonUtil.getPackageId((CollabNetApp)cna, (String)rpackage, (String)(projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project)));
        if (packageId != null) {
            String releaseId2 = CNHudsonUtil.getReleaseId((CollabNetApp)cna, (String)packageId, (String)release);
            if (releaseId2 == null) {
                CNHudsonUtil.logoff((CollabNetApp)cna);
                return FormValidation.warning((String)"Release could not be found.");
            }
        } else if (projectId != null && (releaseId = CNHudsonUtil.getProjectReleaseId((CollabNetApp)cna, (String)projectId, (String)release)) == null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)"Release could not be found.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation repoCheck(StaplerRequest request) {
        String repoId;
        String project = request.getParameter("project");
        String repoName = request.getParameter("repo");
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (CommonUtil.unset((String)repoName)) {
            return FormValidation.error((String)"The repository name is required.");
        }
        if (projectId != null && (repoId = CNHudsonUtil.getRepoId((CollabNetApp)cna, (String)projectId, (String)repoName)) == null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)"Repository could not be found.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation trackerCheck(StaplerRequest request) {
        String trackerId;
        String tracker = request.getParameter("tracker");
        String project = request.getParameter("project");
        if (CommonUtil.unset((String)tracker)) {
            return FormValidation.error((String)"The tracker is required.");
        }
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (projectId != null && (trackerId = CNHudsonUtil.getTrackerId((CollabNetApp)cna, (String)projectId, (String)tracker)) == null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)"Tracker could not be found.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation assignCheck(StaplerRequest request) {
        String assign = StringUtils.strip((String)request.getParameter("assign"));
        if (CommonUtil.unset((String)assign)) {
            return FormValidation.ok();
        }
        String project = request.getParameter("project");
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((StaplerRequest)request);
        if (cna == null) {
            return FormValidation.ok();
        }
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (projectId == null) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.ok();
        }
        if (!CNHudsonUtil.isUserMember((CollabNetApp)cna, (String)assign, (String)projectId)) {
            CNHudsonUtil.logoff((CollabNetApp)cna);
            return FormValidation.warning((String)"This user is not a member of the project.");
        }
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return FormValidation.ok();
    }

    public static FormValidation userListCheck(String userStr) {
        if (userStr == null || userStr.equals("")) {
            return FormValidation.ok();
        }
        CNConnection conn = CNConnection.getInstance();
        if (conn == null || !conn.isSuperUser()) {
            return FormValidation.warning((String)"Cannot check if users exist unless logged in as a TeamForge site admin.  Be careful!");
        }
        Collection invalidUsers = CNFormFieldValidator.getInvalidUsers((CNConnection)conn, (String)userStr);
        if (!invalidUsers.isEmpty()) {
            return FormValidation.error((String)("The following users do not exist: " + invalidUsers));
        }
        return FormValidation.ok();
    }

    private static Collection<String> getInvalidUsers(CNConnection conn, String userStr) {
        String[] users = CommonUtil.splitCommaStr((String)userStr);
        ArrayList<String> invalidUsers = new ArrayList<String>();
        for (String user : users) {
            if (conn.isUsernameValid(user)) continue;
            invalidUsers.add(user);
        }
        return invalidUsers;
    }

    public static FormValidation groupListCheck(String groupStr, String userStr) {
        Collection invalidGroups = CNFormFieldValidator.getInvalidGroups((String)groupStr);
        if (!invalidGroups.isEmpty()) {
            return FormValidation.error((String)("The following groups do not exist: " + invalidGroups));
        }
        if (userStr != null && CNFormFieldValidator.locksOutCurrentUser((String)userStr, (String)groupStr)) {
            return FormValidation.error((String)"The authorization settings would lock the current user out of this page.  You may want to add your username to the user list.");
        }
        return FormValidation.ok();
    }

    private static Collection<String> getInvalidGroups(String groupStr) {
        CNConnection conn = CNConnection.getInstance();
        if (conn == null) {
            return Collections.emptyList();
        }
        if (!conn.isSuperUser()) {
            return Collections.emptyList();
        }
        String[] groups = CommonUtil.splitCommaStr((String)groupStr);
        ArrayList<String> invalidGroups = new ArrayList<String>();
        for (String group : groups) {
            if (conn.isGroupnameValid(group)) continue;
            invalidGroups.add(group);
        }
        return invalidGroups;
    }

    private static boolean locksOutCurrentUser(String userStr, String groupStr) {
        String[] users;
        CNConnection conn = CNConnection.getInstance();
        if (conn == null) {
            return false;
        }
        if (conn.isSuperUser()) {
            return false;
        }
        String currentUser = conn.getUsername();
        for (String user : users = CommonUtil.splitCommaStr((String)userStr)) {
            if (!user.equals(currentUser)) continue;
            return false;
        }
        String[] groups = CommonUtil.splitCommaStr((String)groupStr);
        return !conn.isMemberOfAny(Arrays.asList(groups));
    }

    public static FormValidation regexCheck(String regex) {
        if (!CommonUtil.unset((String)regex)) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.error((String)"The regular expression is not syntactically correct.");
            }
        }
        return FormValidation.ok();
    }

    public static FormValidation cubitKeyCheck(StaplerRequest request) {
        String key = request.getParameter("value");
        String hostURL = request.getParameter("hostURL");
        String user = request.getParameter("user");
        if (CommonUtil.unset((String)key)) {
            return FormValidation.error((String)"The user API key is required.");
        }
        if (!key.matches("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}")) {
            if (key.startsWith(" ")) {
                return FormValidation.error((String)"The key's format is invalid.  There is a leading space.");
            }
            if (key.endsWith(" ")) {
                return FormValidation.error((String)"The key's format is invalid.  There is a trailing space.");
            }
            return FormValidation.error((String)"The key's format is invalid.");
        }
        if (!CommonUtil.unset((String)hostURL) && !CommonUtil.unset((String)user)) {
            boolean success = false;
            try {
                success = CNFormFieldValidator.signedStatus((String)hostURL, (String)user, (String)key);
            }
            catch (IllegalArgumentException iae) {
                success = false;
            }
            if (!success) {
                return FormValidation.warning((String)"This host URL, username, and user API key combination cannot successfully sign in.");
            }
        }
        return FormValidation.ok();
    }

    private static boolean signedStatus(String host, String user, String key) {
        String status;
        key = key.toLowerCase();
        CubitConnector conn = new CubitConnector(host, user, key);
        try {
            status = conn.callCubitApi("status_signed", new HashMap(), true);
        }
        catch (IOException e) {
            return false;
        }
        Pattern pat = Pattern.compile(".*OK.*", 32);
        return pat.matcher(status).matches();
    }
}

