/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.rbac.IRbacAppSoap;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapList;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapRow;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacApp {
    private CollabNetApp collabNetApp;
    private IRbacAppSoap iras;

    public RbacApp(CollabNetApp collabNetApp) {
        this.collabNetApp = collabNetApp;
        this.iras = this.getIRbacAppSoap();
    }

    private IRbacAppSoap getIRbacAppSoap() {
        String soapURL = this.getUrl() + CollabNetApp.SOAP_SERVICE + "RbacApp?wsdl";
        return (IRbacAppSoap)ClientSoapStubFactory.getSoapStub(IRbacAppSoap.class, (String)soapURL);
    }

    public Collection<String> getRoles(String projectId) throws RemoteException {
        this.checkValidSessionId();
        RoleSoapList rsList = this.iras.getRoleList(this.getSessionId(), projectId);
        ArrayList<String> roleNames = new ArrayList<String>();
        for (RoleSoapRow row : rsList.getDataRows()) {
            roleNames.add(row.getTitle());
        }
        return roleNames;
    }

    public boolean addRoles(String projectId, String[] roles, String[] descriptions) throws RemoteException {
        this.checkValidSessionId();
        boolean rolesAdded = false;
        if (roles.length != descriptions.length) {
            throw new IllegalArgumentException("RbacApp: addRoles: the number of role names and descriptions  are not equal.");
        }
        Collection<String> existingRoles = this.getRoles(projectId);
        for (int i = 0; i < roles.length; ++i) {
            if (existingRoles.contains(roles[i])) continue;
            this.addRole(projectId, roles[i], descriptions[i]);
            rolesAdded = true;
        }
        return rolesAdded;
    }

    public void addRole(String projectId, String role, String description) throws RemoteException {
        this.checkValidSessionId();
        this.iras.createRole(this.getSessionId(), projectId, role, description);
    }

    public void grantRole(String projectId, String roleName, String username) throws RemoteException {
        this.checkValidSessionId();
        String roleId = this.findRoleId(projectId, roleName);
        this.iras.addUser(this.getSessionId(), roleId, username);
    }

    private String findRoleId(String projectId, String roleName) throws RemoteException {
        this.checkValidSessionId();
        RoleSoapList rsList = this.iras.getRoleList(this.getSessionId(), projectId);
        for (RoleSoapRow row : rsList.getDataRows()) {
            if (!row.getTitle().equals(roleName)) continue;
            return row.getId();
        }
        return null;
    }

    public Collection<String> getUserRoles(String projectId, String username) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> roles = new ArrayList<String>();
        RoleSoapList rsList = this.iras.getUserRoleList(this.getSessionId(), projectId, username);
        for (int i = 0; i < rsList.getDataRows().length; ++i) {
            roles.add(rsList.getDataRows()[i].getTitle());
        }
        return roles;
    }

    private void checkValidSessionId() {
        this.collabNetApp.checkValidSessionId();
    }

    private String getSessionId() {
        return this.collabNetApp.getSessionId();
    }

    private String getUrl() {
        return this.collabNetApp.getServerUrl();
    }
}

