/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CollabNetSecurityRealm;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;

public class CNFilter
implements Filter {
    private static Logger log = Logger.getLogger("CNFilter");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth = Hudson.getAuthentication();
        SecurityRealm securityRealm = Hudson.getInstance().getSecurityRealm();
        boolean enableSSOFromCTF = false;
        boolean enableSSOToCTF = false;
        if (securityRealm instanceof CollabNetSecurityRealm) {
            CollabNetSecurityRealm cnRealm = (CollabNetSecurityRealm)securityRealm;
            enableSSOFromCTF = cnRealm.getEnableSSOAuthFromCTF();
            enableSSOToCTF = cnRealm.getEnableSSOAuthToCTF();
        }
        if (Hudson.getInstance().isUseSecurity()) {
            CNAuthentication cnauth;
            if (enableSSOFromCTF && (!auth.isAuthenticated() || auth.getPrincipal().equals("anonymous"))) {
                this.loginHudsonUsingCTFSSO((CollabNetSecurityRealm)securityRealm, (HttpServletRequest)request);
            } else if (enableSSOToCTF && auth instanceof CNAuthentication && !(cnauth = (CNAuthentication)auth).isCNAuthed()) {
                this.loginToCTF(cnauth, (CollabNetSecurityRealm)securityRealm, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void loginHudsonUsingCTFSSO(CollabNetSecurityRealm securityRealm, HttpServletRequest request) {
        String url = securityRealm.getCollabNetUrl();
        String username = request.getParameter("sfUsername");
        String token = request.getParameter("sfLoginToken");
        if (username != null && token != null) {
            CollabNetApp ca = new CollabNetApp(url, username);
            try {
                ca.loginWithToken(token);
                CNAuthentication cnauthentication = new CNAuthentication(username, ca);
                request.getSession(true);
                SecurityContextHolder.getContext().setAuthentication((Authentication)cnauthentication);
            }
            catch (RemoteException re) {
                log.severe("Login failed with RemoteException: " + re.getMessage());
            }
        }
    }

    private void loginToCTF(CNAuthentication cnauth, CollabNetSecurityRealm securityRealm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        cnauth.setCNAuthed(true);
        String reqUrl = CNFilter.getCurrentUrl(request);
        String collabNetUrl = securityRealm.getCollabNetUrl();
        String username = (String)cnauth.getPrincipal();
        String id = cnauth.getSessionId();
        String cnauthUrl = collabNetUrl + "/sf/sfmain/do/soapredirect?id=" + URLEncoder.encode(id, "UTF-8") + "&user=" + URLEncoder.encode(username, "UTF-8");
        if (securityRealm.getEnableSSORedirect()) {
            cnauthUrl = cnauthUrl + "&redirectUrl=" + URLEncoder.encode(reqUrl, "UTF-8");
        }
        response.setStatus(302);
        response.setHeader("Location", cnauthUrl);
    }

    public static String getCurrentBaseUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder();
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            url.append(rootUrl);
        } else {
            url.append(req.getScheme());
            url.append("://");
            url.append(req.getServerName());
            if (req.getServerPort() != 80) {
                url.append(':').append(req.getServerPort());
            }
            url.append(req.getContextPath());
        }
        return url.toString();
    }

    public static String getCurrentUrl(HttpServletRequest req) {
        String curBaseUrl = CNFilter.getCurrentBaseUrl(req);
        curBaseUrl = CommonUtil.stripSlashes(curBaseUrl);
        curBaseUrl = StringUtils.removeEnd((String)curBaseUrl, (String)req.getContextPath());
        StringBuilder url = new StringBuilder(curBaseUrl);
        if (req.getRequestURI() != null) {
            url.append(req.getRequestURI());
        }
        if (req.getQueryString() != null) {
            url.append("?" + req.getQueryString());
        }
        return url.toString();
    }

    public void destroy() {
    }
}

