/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.cemain.Group2SoapList;
import com.collabnet.ce.soap50.webservices.cemain.Group2SoapRow;
import com.collabnet.ce.soap50.webservices.cemain.GroupSoapList;
import com.collabnet.ce.soap50.webservices.cemain.GroupSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.ICollabNetSoap;
import com.collabnet.ce.soap50.webservices.cemain.ProjectMemberSoapList;
import com.collabnet.ce.soap50.webservices.cemain.ProjectMemberSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.ProjectSoapList;
import com.collabnet.ce.soap50.webservices.cemain.ProjectSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapList;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapRow;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CollabNetApp {
    private static Logger logger = Logger.getLogger(CollabNetApp.class);
    public static String SOAP_SERVICE = "/ce-soap50/services/";
    private String sessionId;
    private String username;
    private String url;
    private ICollabNetSoap icns;

    public CollabNetApp(String url, String username, String password) throws RemoteException {
        this(url, username);
        this.sessionId = this.login(password);
    }

    public CollabNetApp(String url, String username) {
        this(url);
        this.username = username;
    }

    public CollabNetApp(String url) {
        this.url = url;
        this.icns = this.getICollabNetSoap();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getServerUrl() {
        return this.url;
    }

    private ICollabNetSoap getICollabNetSoap() {
        String soapURL = this.url + SOAP_SERVICE + "CollabNet?wsdl";
        return (ICollabNetSoap)ClientSoapStubFactory.getSoapStub(ICollabNetSoap.class, (String)soapURL);
    }

    private static ICollabNetSoap getICollabNetSoap(String url) {
        String soapURL = url + SOAP_SERVICE + "CollabNet?wsdl";
        return (ICollabNetSoap)ClientSoapStubFactory.getSoapStub(ICollabNetSoap.class, (String)soapURL);
    }

    private String login(String password) throws RemoteException {
        this.sessionId = this.icns.login(this.username, password);
        return this.sessionId;
    }

    public void loginWithToken(String token) throws RemoteException {
        this.sessionId = this.icns.loginWithToken(this.username, token);
    }

    public void logoff() throws RemoteException {
        this.checkValidSessionId();
        this.icns.logoff(this.username, this.sessionId);
        this.sessionId = null;
    }

    public static String getApiVersion(String url) throws RemoteException {
        return CollabNetApp.getICollabNetSoap((String)url).getApiVersion();
    }

    public String getApiVersion() throws RemoteException {
        return this.icns.getApiVersion();
    }

    public String getVersion() throws RemoteException {
        this.checkValidSessionId();
        return this.icns.getVersion(this.sessionId);
    }

    public String getProjectId(String projectName) throws RemoteException {
        this.checkValidSessionId();
        ProjectSoapList pslist = this.icns.getProjectList(this.sessionId);
        ProjectSoapRow[] rows = pslist.getDataRows();
        for (int i = 0; i < rows.length; ++i) {
            logger.debug((Object)(rows[i].getId() + " " + rows[i].getTitle()));
            if (!rows[i].getTitle().equals(projectName)) continue;
            return rows[i].getId();
        }
        return null;
    }

    public Collection<String> getProjects() throws RemoteException {
        this.checkValidSessionId();
        ProjectSoapList pslist = this.icns.getProjectList(this.sessionId);
        ArrayList<String> names = new ArrayList<String>();
        for (ProjectSoapRow row : pslist.getDataRows()) {
            names.add(row.getTitle());
        }
        return names;
    }

    public boolean isUsernameValid(String username) throws RemoteException {
        this.checkValidSessionId();
        UserSoapList usList = this.icns.findUsers(this.sessionId, username);
        for (UserSoapRow row : usList.getDataRows()) {
            if (!row.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserMemberOfProject(String username, String projectId) throws RemoteException {
        this.checkValidSessionId();
        ProjectMemberSoapList pmList = this.icns.getProjectMemberList(this.sessionId, projectId);
        for (ProjectMemberSoapRow row : pmList.getDataRows()) {
            if (!row.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserMemberOfGroup(String username, String group) throws RemoteException {
        this.checkValidSessionId();
        GroupSoapList gList = this.icns.getUserGroupList(this.sessionId, username);
        for (GroupSoapRow row : gList.getDataRows()) {
            if (!row.getFullName().equals(group)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getUserGroups(String username) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> groups = new ArrayList<String>();
        GroupSoapList gList = this.icns.getUserGroupList(this.sessionId, username);
        for (GroupSoapRow row : gList.getDataRows()) {
            groups.add(row.getFullName());
        }
        return groups;
    }

    public boolean isUserProjectAdmin(String username, String projectId) throws RemoteException {
        this.checkValidSessionId();
        UserSoapList usList = this.icns.listProjectAdmins(this.sessionId, projectId);
        for (UserSoapRow row : usList.getDataRows()) {
            if (!row.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserSuper(String username) throws RemoteException {
        this.checkValidSessionId();
        UserSoapList usList = this.icns.findUsers(this.sessionId, username);
        for (UserSoapRow row : usList.getDataRows()) {
            if (!row.getUserName().equals(username)) continue;
            return row.getSuperUser();
        }
        return false;
    }

    public Collection<String> getUsers(String projectId) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> users = new ArrayList<String>();
        ProjectMemberSoapList pmList = this.icns.getProjectMemberList(this.sessionId, projectId);
        for (ProjectMemberSoapRow row : pmList.getDataRows()) {
            users.add(row.getUserName());
        }
        return users;
    }

    public Collection<String> getAdmins(String projectId) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> admins = new ArrayList<String>();
        UserSoapList usList = this.icns.listProjectAdmins(this.sessionId, projectId);
        for (UserSoapRow row : usList.getDataRows()) {
            admins.add(row.getUserName());
        }
        return admins;
    }

    public Map<String, String> getGroups() throws RemoteException {
        this.checkValidSessionId();
        HashMap<String, String> nameId = new HashMap<String, String>();
        Group2SoapList gsList = this.icns.getGroupList2(this.sessionId, null);
        for (Group2SoapRow row : gsList.getDataRows()) {
            nameId.put(row.getFullName(), row.getId());
        }
        return nameId;
    }

    public Collection<String> getUsersInGroups(Collection<String> groupNames) throws RemoteException {
        this.checkValidSessionId();
        Map groupNameIds = this.getGroups();
        HashSet<String> users = new HashSet<String>();
        for (String groupName : groupNames) {
            String id = (String)groupNameIds.get(groupName);
            if (id == null) continue;
            users.addAll(this.getGroupUsers(id));
        }
        return users;
    }

    public Collection<String> getGroupUsers(String groupId) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> users = new ArrayList<String>();
        UserSoapList usList = this.icns.getActiveGroupMembers(this.sessionId, groupId);
        for (UserSoapRow row : usList.getDataRows()) {
            users.add(row.getUserName());
        }
        return users;
    }

    public void checkValidSessionId() {
        if (this.sessionId == null) {
            throw new CollabNetAppException("Not currently in a valid session.");
        }
    }
}

