/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollabNetRole {
    private String name;
    private String description;
    private Collection<Permission> permissions;

    public CollabNetRole(String name, String description, Collection<Permission> permissions) {
        this.name = name;
        this.description = description;
        this.permissions = permissions != null ? new ArrayList<Permission>(permissions) : new ArrayList();
    }

    public CollabNetRole(String name, String description) {
        this.name = name;
        this.description = description;
        this.permissions = new ArrayList();
    }

    public CollabNetRole(String name) {
        this.name = name;
        this.permissions = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CollabNetRole other = (CollabNetRole)obj;
        return other.getName().equals(this.getName());
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        return this.name.hashCode();
    }

    public String toString() {
        String str = "CollabNetRole: {name: " + this.getName() + ", description: " + this.getDescription() + ", permissions: " + this.getPermissions();
        return str;
    }
}

