/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import groovy.lang.Binding;
import hudson.plugins.collabnet.auth.CollabNetAuthManager;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.security.SecurityRealm;
import hudson.util.spring.BeanBuilder;
import java.rmi.RemoteException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.acegisecurity.AuthenticationManager;
import org.springframework.web.context.WebApplicationContext;

public class CollabNetSecurityRealm
extends SecurityRealm {
    private String collabNetUrl;
    private boolean mEnableSSOAuthFromCTF;
    private boolean mEnableSSOAuthToCTF;
    private boolean mEnableSSORedirect = true;

    public CollabNetSecurityRealm(String collabNetUrl, Boolean enableAuthFromCTF, Boolean enableAuthToCTF) {
        this.collabNetUrl = CNHudsonUtil.sanitizeCollabNetUrl((String)collabNetUrl);
        this.mEnableSSOAuthFromCTF = Boolean.TRUE.equals(enableAuthFromCTF);
        this.mEnableSSOAuthToCTF = Boolean.TRUE.equals(enableAuthToCTF);
        CollabNetApp cn = new CollabNetApp(this.collabNetUrl);
        int[] apiVersion = null;
        try {
            apiVersion = CNHudsonUtil.getVersionArray((String)cn.getApiVersion());
        }
        catch (RemoteException re) {
            // empty catch block
        }
        if (CNHudsonUtil.compareVersion((int[])apiVersion, (int[])new int[]{5, 3, 0, 0}) >= 0) {
            this.mEnableSSORedirect = false;
        }
    }

    public String getCollabNetUrl() {
        return this.collabNetUrl;
    }

    public boolean getEnableSSOAuthFromCTF() {
        return this.mEnableSSOAuthFromCTF;
    }

    public boolean getEnableSSOAuthToCTF() {
        return this.mEnableSSOAuthToCTF;
    }

    public boolean getEnableSSORedirect() {
        return this.mEnableSSORedirect;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new CollabNetAuthManager(this.getCollabNetUrl()));
    }

    public Filter createFilter(FilterConfig filterConfig) {
        Binding binding = new Binding();
        SecurityRealm.SecurityComponents sc = this.createSecurityComponents();
        binding.setVariable("securityComponents", (Object)sc);
        BeanBuilder builder = new BeanBuilder(this.getClass().getClassLoader());
        builder.parse(this.getClass().getResourceAsStream("CNSecurityFilters.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return (Filter)context.getBean("filter");
    }
}

