/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.collabnet.auth.CNAuthProjectProperty;
import hudson.plugins.collabnet.auth.CNAuthenticatedUserACL;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CNRootACL;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CNAuthorizationStrategy
extends AuthorizationStrategy {
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private ACL rootACL;
    private static Logger log = Logger.getLogger("CNAuthorizationStrategy");

    public CNAuthorizationStrategy(String[] readUsers, String[] readGroups, String[] adminUsers, String[] adminGroups) {
        this.readUsers = Arrays.asList(readUsers);
        this.readGroups = Arrays.asList(readGroups);
        this.adminUsers = Arrays.asList(adminUsers);
        this.adminGroups = Arrays.asList(adminGroups);
        this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
    }

    public String getReadUsersStr() {
        if (this.readUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join((Collection)this.readUsers, (String)", ");
    }

    public String getReadGroupsStr() {
        if (this.readGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join((Collection)this.readGroups, (String)", ");
    }

    public String getAdminUsersStr() {
        if (this.adminUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join((Collection)this.adminUsers, (String)", ");
    }

    public String getAdminGroupsStr() {
        if (this.adminGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join((Collection)this.adminGroups, (String)", ");
    }

    public static String join(Collection<String> strs, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            String next = it.next();
            buf.append(next);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public Collection<String> getGroups() {
        return CNProjectACL.CollabNetRoles.getNames();
    }

    public ACL getRootACL() {
        if (this.rootACL == null) {
            this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
        }
        return this.rootACL;
    }

    public ACL getACL(Job<?, ?> job) {
        String projectName;
        CNAuthProjectProperty capp = (CNAuthProjectProperty)job.getProperty(CNAuthProjectProperty.class);
        if (capp != null && (projectName = capp.getProject()) != null && !projectName.equals("")) {
            return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, (ACL)new CNProjectACL(projectName));
        }
        return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, (ACL)new CNAuthenticatedUserACL());
    }

    public ACL getACL(AbstractItem item) {
        return this.getRootACL();
    }

    public ACL getACL(AbstractProject<?, ?> project) {
        return this.getACL(project);
    }

    public ACL getACL(View view) {
        return this.getRootACL();
    }

    public ACL getACL(Computer computer) {
        return this.getRootACL();
    }

    public ACL getACL(User user) {
        return this.getRootACL();
    }
}

