/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collection;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class CNProjectACL
extends ACL {
    private String project;
    private String projectId = null;
    private static Logger log = Logger.getLogger("CNProjectACL");

    public CNProjectACL(String project) {
        this.project = project;
    }

    public String getProjectId(CNConnection conn) {
        if (this.projectId == null) {
            this.projectId = conn.getProjectId(this.project);
        }
        return this.projectId;
    }

    public boolean hasPermission(Authentication a, Permission permission) {
        CNConnection conn = CNConnection.getInstance((Authentication)a);
        if (conn == null) {
            log.severe("Improper Authentication type used with CNAuthorizationStrategy!  CNAuthorization strategy cannot be used without CNAuthentication.  Please re-configure your Hudson instance.");
            return false;
        }
        String projId = this.getProjectId(conn);
        if (projId == null) {
            log.severe("hasPerission: project id could not be found for project: " + this.project + ".");
            return false;
        }
        Collection userRoles = CollabNetRoles.getRoles((Collection)conn.getUserRoles(projId, conn.getUsername()));
        while (permission != null) {
            for (CollabNetRole role : userRoles) {
                if (!role.hasPermission(permission)) continue;
                return true;
            }
            permission = permission.impliedBy;
        }
        return false;
    }
}

