/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.browser;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.plugins.collabnet.browser.OverrideAuth;
import hudson.plugins.collabnet.browser.TeamForge;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeamForge
extends SubversionRepositoryBrowser {
    private static Logger log = Logger.getLogger("TeamForge");
    private String collabneturl;
    private String username;
    private String password;
    private String project;
    private String repo;
    private boolean overrideAuth;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TeamForge(String collabneturl, String username, String password, String project, String repo, OverrideAuth override_auth) {
        if (override_auth != null) {
            this.overrideAuth = true;
            this.collabneturl = override_auth.collabneturl;
            this.username = override_auth.username;
            this.password = override_auth.password;
        } else if (collabneturl == null && username == null && password == null) {
            this.overrideAuth = false;
        } else {
            this.overrideAuth = true;
            this.collabneturl = CNHudsonUtil.sanitizeCollabNetUrl((String)collabneturl);
            this.username = username;
            this.password = password;
        }
        this.project = project;
        this.repo = repo;
    }

    public TeamForge(String collabneturl, String username, String password, String project, String repo, boolean overrideAuth) {
        this.collabneturl = CNHudsonUtil.sanitizeCollabNetUrl((String)collabneturl);
        this.username = username;
        this.password = password;
        this.project = project;
        this.repo = repo;
        this.overrideAuth = overrideAuth;
    }

    public TeamForge(String project, String repo, boolean overrideAuth) {
        this(null, null, null, project, repo, overrideAuth);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean overrideAuth() {
        return this.overrideAuth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.collabneturl;
        }
        return TeamForge.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return TeamForge.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password;
        }
        return TeamForge.getTeamForgeShareDescriptor().getPassword();
    }

    public String getProject() {
        return this.project;
    }

    public String getRepo() {
        return this.repo;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        Collection projects = ComboBoxUpdater.ProjectsUpdater.getProjectList((CollabNetApp)cna);
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return projects.toArray(new String[0]);
    }

    public String[] getRepos() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        Collection repos = ComboBoxUpdater.ReposUpdater.getRepoList((CollabNetApp)cna, (String)this.getProject());
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return repos.toArray(new String[0]);
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&view=markup");
        return new URL(link.toString());
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        int revision = path.getLogEntry().getRevision();
        int r1 = revision - 1;
        int r2 = revision;
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&r1=").append(r1).append("&r2=").append(r2);
        return new URL(link.toString());
    }

    private StringBuffer getViewerUrlWithPath(SubversionChangeLogSet.Path path) {
        String[] urlParts = this.getViewerUrl().split("\\?");
        StringBuffer viewWithPath = new StringBuffer(urlParts[0]).append(path.getValue()).append("?");
        if (urlParts.length > 1) {
            viewWithPath.append(urlParts[1]);
        }
        return viewWithPath;
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int revision = changeSet.getRevision();
        StringBuffer link = new StringBuffer(this.getViewerUrl()).append("?view=revision&system=").append(this.getSystemId()).append("&revision=").append(revision);
        return new URL(link.toString());
    }

    private String getViewerUrl() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        return CNHudsonUtil.getScmViewerUrl((CollabNetApp)cna, (String)this.getCollabNetUrl(), (String)this.getProject(), (String)this.getRepo());
    }

    private String getSystemId() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        return CNHudsonUtil.getSystemId((CollabNetApp)cna, (String)this.getProject(), (String)this.getRepo());
    }
}

