/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.scm.IScmAppSoap;
import com.collabnet.ce.soap50.webservices.scm.Repository2SoapDO;
import com.collabnet.ce.soap50.webservices.scm.RepositorySoapList;
import com.collabnet.ce.soap50.webservices.scm.RepositorySoapRow;
import com.collabnet.ce.webservices.AbstractSoapApp;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmApp
extends AbstractSoapApp {
    private IScmAppSoap isas = this.getIScmAppSoap();

    public ScmApp(CollabNetApp collabNetApp) {
        super(collabNetApp);
    }

    private IScmAppSoap getIScmAppSoap() {
        String soapURL = this.getServerUrl() + CollabNetApp.SOAP_SERVICE + "ScmApp?wsdl";
        return (IScmAppSoap)ClientSoapStubFactory.getSoapStub(IScmAppSoap.class, (String)soapURL);
    }

    public String getRepoId(String projectId, String repoName) throws RemoteException {
        this.checkValidSessionId();
        RepositorySoapList repoList = this.isas.getRepositoryList(this.getSessionId(), projectId);
        for (RepositorySoapRow row : repoList.getDataRows()) {
            if (!row.getTitle().equals(repoName)) continue;
            return row.getId();
        }
        return null;
    }

    public Repository2SoapDO getRepoData(String repoId) throws RemoteException {
        this.checkValidSessionId();
        return this.isas.getRepositoryData2(this.getSessionId(), repoId);
    }

    public Collection<String> getRepos(String projectId) throws RemoteException {
        this.checkValidSessionId();
        RepositorySoapList repoList = this.isas.getRepositoryList(this.getSessionId(), projectId);
        ArrayList<String> repoNames = new ArrayList<String>(repoList.getDataRows().length);
        for (RepositorySoapRow row : repoList.getDataRows()) {
            repoNames.add(row.getTitle());
        }
        return repoNames;
    }
}

