/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.collabnet.auth.CNAuthProjectProperty;
import hudson.plugins.collabnet.auth.CNAuthenticatedUserACL;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CNRootACL;
import hudson.plugins.collabnet.auth.CNVersion;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthorizationStrategy
extends AuthorizationStrategy {
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private ACL rootACL;
    private static Logger log = Logger.getLogger("CNAuthorizationStrategy");

    public CNAuthorizationStrategy(String[] readUsers, String[] readGroups, String[] adminUsers, String[] adminGroups) {
        this.readUsers = Arrays.asList(readUsers);
        this.readGroups = Arrays.asList(readGroups);
        this.adminUsers = Arrays.asList(adminUsers);
        this.adminGroups = Arrays.asList(adminGroups);
        this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
    }

    public String getReadUsersStr() {
        if (this.readUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.readUsers, ", ");
    }

    public String getReadGroupsStr() {
        if (this.readGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.readGroups, ", ");
    }

    public String getAdminUsersStr() {
        if (this.adminUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.adminUsers, ", ");
    }

    public String getAdminGroupsStr() {
        if (this.adminGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.adminGroups, ", ");
    }

    public static String join(Collection<String> strs, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            String next = it.next();
            buf.append(next);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public Collection<String> getGroups() {
        return CNProjectACL.CollabNetRoles.getNames();
    }

    public ACL getRootACL() {
        if (this.rootACL == null) {
            this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
        }
        return this.rootACL;
    }

    public ACL getACL(Job<?, ?> job) {
        String projectName;
        CNAuthProjectProperty capp = (CNAuthProjectProperty)job.getProperty(CNAuthProjectProperty.class);
        if (capp != null && (projectName = capp.getProject()) != null && !projectName.equals("")) {
            return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, new CNProjectACL(projectName));
        }
        return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, new CNAuthenticatedUserACL());
    }

    public ACL getACL(AbstractItem item) {
        return this.getRootACL();
    }

    public ACL getACL(AbstractProject<?, ?> project) {
        return this.getACL((Job<?, ?>)project);
    }

    public ACL getACL(View view) {
        return this.getRootACL();
    }

    public ACL getACL(Computer computer) {
        return this.getRootACL();
    }

    public ACL getACL(User user) {
        return this.getRootACL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public static String GOOD_VERSION = "5.2.0.0";

        public DescriptorImpl() {
            super(CNAuthorizationStrategy.class);
        }

        public String getDisplayName() {
            return "CollabNet Authorization";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/auth/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-authStrategy.html";
        }

        public CNAuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] readUsers = CommonUtil.splitCommaStr((String)formData.get("readUsers"));
            String[] readGroups = CommonUtil.splitCommaStr((String)formData.get("readGroups"));
            String[] adminUsers = CommonUtil.splitCommaStr((String)formData.get("adminUsers"));
            String[] adminGroups = CommonUtil.splitCommaStr((String)formData.get("adminGroups"));
            return new CNAuthorizationStrategy(readUsers, readGroups, adminUsers, adminGroups);
        }

        public static String getCollabNetUrl() {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return null;
            }
            return conn.getCollabNetApp().getServerUrl();
        }

        public static CNVersion getVersion(String url) {
            if (url == null) {
                return null;
            }
            return CNConnection.getVersion(url);
        }

        public static boolean isGoodCNVersion(String url) {
            CNVersion version = DescriptorImpl.getVersion(url);
            if (version == null) {
                return true;
            }
            CNVersion desiredVersion = new CNVersion(GOOD_VERSION);
            return version.compareTo(desiredVersion) >= 0;
        }

        public void doVersionCheck(StaplerRequest req, StaplerResponse rsp) throws IOException {
            String url = req.getParameter("url");
            rsp.setContentType("text/plain;charset=UTF-8");
            JSONObject versionJSON = new JSONObject();
            String error_display_style = "none";
            if (!DescriptorImpl.isGoodCNVersion(url)) {
                error_display_style = "inline";
            }
            versionJSON.element("error_display_style", (Object)error_display_style);
            CNVersion version = DescriptorImpl.getVersion(url);
            if (version != null) {
                versionJSON.element("version", (Object)DescriptorImpl.getVersion(url).toString());
            } else {
                versionJSON.element("version", (Object)"unknown");
            }
            rsp.getWriter().print(versionJSON.toString());
        }

        public FormValidation doUserCheck(@QueryParameter String value) {
            return CNFormFieldValidator.userListCheck(value);
        }

        public FormValidation doGroupCheck(@QueryParameter String groups, @QueryParameter String users) {
            return CNFormFieldValidator.groupListCheck(groups, users);
        }
    }
}

