/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import groovy.lang.Binding;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CollabNetAuthManager;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import net.sf.json.JSONObject;
import org.acegisecurity.AuthenticationManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.web.context.WebApplicationContext;

public class CollabNetSecurityRealm
extends SecurityRealm {
    private String collabNetUrl;
    private boolean mEnableSSOAuthFromCTF;
    private boolean mEnableSSOAuthToCTF;
    private boolean mEnableSSORedirect = true;

    public CollabNetSecurityRealm(String collabNetUrl, Boolean enableAuthFromCTF, Boolean enableAuthToCTF) {
        this.collabNetUrl = CNHudsonUtil.sanitizeCollabNetUrl(collabNetUrl);
        this.mEnableSSOAuthFromCTF = Boolean.TRUE.equals(enableAuthFromCTF);
        this.mEnableSSOAuthToCTF = Boolean.TRUE.equals(enableAuthToCTF);
        CollabNetApp cn = new CollabNetApp(this.collabNetUrl);
        int[] apiVersion = null;
        try {
            apiVersion = CNHudsonUtil.getVersionArray(cn.getApiVersion());
        }
        catch (RemoteException re) {
            // empty catch block
        }
        if (CNHudsonUtil.compareVersion(apiVersion, new int[]{5, 3, 0, 0}) >= 0) {
            this.mEnableSSORedirect = false;
        }
    }

    public String getCollabNetUrl() {
        return this.collabNetUrl;
    }

    public boolean getEnableSSOAuthFromCTF() {
        return this.mEnableSSOAuthFromCTF;
    }

    public boolean getEnableSSOAuthToCTF() {
        return this.mEnableSSOAuthToCTF;
    }

    public boolean getEnableSSORedirect() {
        return this.mEnableSSORedirect;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new CollabNetAuthManager(this.getCollabNetUrl()));
    }

    public Filter createFilter(FilterConfig filterConfig) {
        Binding binding = new Binding();
        SecurityRealm.SecurityComponents sc = this.createSecurityComponents();
        binding.setVariable("securityComponents", (Object)sc);
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("CNSecurityFilters.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return (Filter)context.getBean("filter");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
            super(CollabNetSecurityRealm.class);
        }

        public String getDisplayName() {
            return "CollabNet Security Realm";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/auth/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-securityRealm.html";
        }

        public CollabNetSecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new CollabNetSecurityRealm((String)formData.get("collabneturl"), (Boolean)formData.get("enablessofrom"), (Boolean)formData.get("enablessoto"));
        }

        public FormValidation doCollabNetUrlCheck(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            String collabNetUrl = value;
            if (collabNetUrl == null || collabNetUrl.equals("")) {
                return FormValidation.error((String)"The CollabNet URL is required.");
            }
            if (!this.checkSoapUrl(collabNetUrl)) {
                return FormValidation.error((String)"Invalid CollabNet URL.");
            }
            return FormValidation.ok();
        }

        private boolean checkSoapUrl(String collabNetUrl) {
            String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
            HttpClient client = new HttpClient();
            try {
                GetMethod get = new GetMethod(soapURL);
                int status = client.executeMethod((HttpMethod)get);
                return status == 200;
            }
            catch (IOException e) {
                return false;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }
}

