/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.documentuploader;

import com.collabnet.ce.soap50.webservices.docman.DocumentSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.DocumentApp;
import com.collabnet.ce.webservices.FileStorageApp;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.documentuploader.CnduResultAction;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNDocumentUploader
extends Notifier {
    private static Logger logger = Logger.getLogger("CNDocumentUploader");
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private transient BuildListener listener = null;
    private transient CollabNetApp cna = null;
    private boolean override_auth = true;
    private String url;
    private String username;
    private String password;
    private String project;
    private String uploadPath;
    private String description;
    private String[] file_patterns;
    private boolean includeBuildLog;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;

    public CNDocumentUploader(String url, String username, String password, String project, String uploadPath, String description, String[] filePatterns, boolean includeBuildLog, boolean override_auth) {
        this.url = CNHudsonUtil.sanitizeCollabNetUrl(url);
        this.username = username;
        this.password = password;
        this.project = project;
        this.uploadPath = uploadPath;
        this.description = description;
        this.file_patterns = filePatterns;
        this.includeBuildLog = includeBuildLog;
        this.override_auth = override_auth;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            message = "CollabNet Document Uploader: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        CommonUtil.logRE(logger, methodName, re);
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.url;
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password;
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getPassword();
    }

    public String getProject() {
        return this.project;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new String[0];
    }

    public boolean includeBuildLog() {
        return this.includeBuildLog;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        Collection<String> projects = ComboBoxUpdater.ProjectsUpdater.getProjectList(cna);
        CNHudsonUtil.logoff(cna);
        return projects.toArray(new String[0]);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.setupLogging(listener);
        this.cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        if (this.cna == null) {
            this.log("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, null));
            return false;
        }
        String projectId = this.getProjectId();
        if (projectId == null) {
            this.log("Critical Error: Unable to find project '" + this.getProject() + "'.  " + "Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, null));
            this.logoff();
            return false;
        }
        DocumentApp da = new DocumentApp(this.cna);
        String folderId = null;
        String path = this.getInterpreted(build, this.getUploadPath());
        try {
            folderId = da.findOrCreatePath(projectId, path);
        }
        catch (RemoteException re) {
            this.log("findOrCreatePath", re);
            this.log("Critical Error: Unable to create a path for '" + path + "'.  Setting build status to " + "UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, folderId));
            this.logoff();
            return false;
        }
        int numUploaded = this.uploadFiles(folderId, build);
        build.addAction(this.createAction(numUploaded, folderId));
        try {
            this.cna.logoff();
        }
        catch (RemoteException re) {
            this.log("logoff", re);
        }
        return true;
    }

    private Action createAction(int numUploaded, String folderId) {
        String displaymsg = "Download from CollabNet Documents";
        return new CnduResultAction(displaymsg, "/plugin/collabnet/images/48x48/cn-icon.gif", "console", this.getFolderUrl(folderId), numUploaded);
    }

    private String getFolderUrl(String folderId) {
        String path = null;
        if (folderId != null) {
            try {
                DocumentApp da = new DocumentApp(this.cna);
                path = da.getFolderPath(folderId);
            }
            catch (RemoteException re) {
                this.log("getFolderUrl", re);
            }
        }
        if (path == null) {
            return this.getCollabNetUrl();
        }
        return this.getCollabNetUrl() + "/sf/docman/do/listDocuments/" + path;
    }

    public int uploadFiles(String folderId, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        int numUploaded = 0;
        String path = this.getInterpreted(build, this.getUploadPath());
        this.log("Uploading files to project '" + this.getProject() + "', folder '" + path + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (String uninterp_fp : this.getFilePatterns()) {
            String file_pattern = "";
            try {
                file_pattern = this.getInterpreted(build, uninterp_fp);
            }
            catch (IllegalArgumentException e) {
                this.log("File pattern " + uninterp_fp + " contained a bad " + "env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals("")) continue;
            this.log("Upload files matching " + file_pattern + ":");
            for (FilePath uploadFilePath : this.getFilePaths(build, file_pattern)) {
                String fileId = this.uploadFile(uploadFilePath);
                if (fileId == null) {
                    this.log("Failed to upload " + uploadFilePath.getName() + ".");
                    continue;
                }
                String docId = null;
                try {
                    docId = this.updateOrCreateDoc(folderId, fileId, uploadFilePath.getName(), CNDocumentUploader.getMimeType(uploadFilePath), build);
                    this.log("Uploaded " + uploadFilePath.getName() + " -> " + this.getDocUrl(docId));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        if (this.includeBuildLog()) {
            String fileId = this.uploadBuildLog(build);
            if (fileId == null) {
                this.log("Failed to upload " + build.getLogFile().getName() + ".");
            } else {
                String docId = null;
                try {
                    docId = this.updateOrCreateDoc(folderId, fileId, build.getLogFile().getName(), CNDocumentUploader.getMimeType(build.getLogFile()), build);
                    this.log("Uploaded " + build.getLogFile().getName() + " -> " + this.getDocUrl(docId));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        return numUploaded;
    }

    private String getDocUrl(String docId) {
        return this.getCollabNetUrl() + "/sf/go/" + docId;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = build.getWorkspace();
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
        }
        catch (IOException ioe) {
            this.log("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.log("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        return uploadFilePaths;
    }

    private String updateOrCreateDoc(String folderId, String fileId, String fileName, String mimeType, AbstractBuild<?, ?> build) throws RemoteException, IOException, InterruptedException {
        DocumentApp da = new DocumentApp(this.cna);
        String docId = da.findDocumentId(folderId, fileName);
        if (docId != null) {
            da.updateDoc(docId, fileId);
        } else {
            DocumentSoapDO document = da.createDocument(folderId, fileName, this.getInterpreted(build, this.getDescription()), null, "final", false, fileName, mimeType, fileId, null, null);
            docId = document.getId();
        }
        return docId;
    }

    public static String getMimeType(FilePath filePath) {
        String mimeType = "text/plain";
        try {
            mimeType = (String)filePath.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, RemoteException {
                    if (f.getName().endsWith("log")) {
                        return "text/plain";
                    }
                    return new MimetypesFileTypeMap().getContentType(f);
                }
            });
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return mimeType;
    }

    public static String getMimeType(File f) {
        if (f.getName().endsWith("log")) {
            return "text/plain";
        }
        return new MimetypesFileTypeMap().getContentType(f);
    }

    private String uploadBuildLog(AbstractBuild<?, ?> build) {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return null;
        }
        String id = null;
        FileStorageApp sfsa = new FileStorageApp(this.cna);
        try {
            id = sfsa.uploadFile(build.getLogFile());
        }
        catch (RemoteException re) {
            this.log("uploadBuildLog", re);
        }
        return id;
    }

    private String uploadFile(FilePath filePath) {
        if (this.cna == null) {
            this.log("Cannot call uploadFile, not logged in!");
            return null;
        }
        String id = null;
        final FileStorageApp sfsa = new FileStorageApp(this.cna);
        try {
            id = (String)filePath.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, RemoteException {
                    return sfsa.uploadFile(f);
                }
            });
        }
        catch (RemoteException re) {
            this.log("upload file", re);
        }
        catch (IOException ioe) {
            this.log("Could not upload file due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.log("Could not upload file due to InterruptedException: " + ie.getMessage());
        }
        return id;
    }

    public void logoff() {
        CNHudsonUtil.logoff(this.cna);
        this.cna = null;
    }

    public String getProjectId() {
        if (this.cna == null) {
            this.log("Cannot getProjectId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getProjectId(this.cna, this.getProject());
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        try {
            return CommonUtil.getInterpreted((Map<String, String>)build.getEnvironment(TaskListener.NULL), str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static int smUniqueIdCounter = 0;

        public DescriptorImpl() {
            super(CNDocumentUploader.class);
        }

        public synchronized int getUniqueId() {
            int returnVal;
            block0: {
                if ((returnVal = smUniqueIdCounter++) != 0x7FFFFFFE) break block0;
                smUniqueIdCounter = 0;
            }
            return returnVal;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "CollabNet Document Uploader";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/documentuploader";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "/help-main.html";
        }

        public boolean canInheritAuth() {
            return CNDocumentUploader.getTeamForgeShareDescriptor().useGlobal();
        }

        public CNDocumentUploader newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject[] jpats;
            boolean override_auth = false;
            String username = null;
            String password = null;
            String collabneturl = null;
            if (formData.has("override_auth")) {
                override_auth = true;
                Object authObject = formData.get("override_auth");
                if (authObject instanceof JSONObject) {
                    username = (String)((JSONObject)authObject).get("username");
                    password = (String)((JSONObject)authObject).get("password");
                    collabneturl = (String)((JSONObject)authObject).get("collabneturl");
                } else if (authObject.equals(Boolean.TRUE)) {
                    username = (String)formData.get("username");
                    password = (String)formData.get("password");
                    collabneturl = (String)formData.get("collabneturl");
                } else {
                    override_auth = false;
                }
            } else if (!this.canInheritAuth()) {
                override_auth = true;
                username = (String)formData.get("username");
                password = (String)formData.get("password");
                collabneturl = (String)formData.get("collabneturl");
            }
            Object fileData = formData.get("files");
            if (fileData instanceof JSONArray) {
                JSONArray patData = (JSONArray)fileData;
                jpats = (JSONObject[])JSONArray.toArray((JSONArray)patData, JSONObject.class);
            } else {
                jpats = fileData instanceof JSONObject ? new JSONObject[]{(JSONObject)fileData} : new JSONObject[]{};
            }
            String[] patterns = new String[jpats.length];
            for (int i = 0; i < jpats.length; ++i) {
                patterns[i] = (String)jpats[i].get("file");
            }
            String path = (String)formData.get("upload_path");
            path = path.replaceAll("/+", "/");
            path = CommonUtil.stripSlashes(path);
            return new CNDocumentUploader(collabneturl, username, password, (String)formData.get("project"), path, (String)formData.get("description"), patterns, CommonUtil.getBoolean("buildlog", formData), override_auth);
        }

        public FormValidation doCollabNetUrlCheck(@QueryParameter String value) {
            return CNFormFieldValidator.soapUrlCheck(value);
        }

        public FormValidation doRequiredCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredCheck(value, name);
        }

        public FormValidation doPasswordCheck(StaplerRequest req) {
            return CNFormFieldValidator.loginCheck(req);
        }

        public FormValidation doProjectCheck(StaplerRequest req) {
            return CNFormFieldValidator.projectCheck(req);
        }

        public FormValidation doPathCheck(StaplerRequest req) throws IOException {
            return CNFormFieldValidator.documentPathCheck(req);
        }

        public FormValidation doUnRequiredInterpretedCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.unrequiredInterpretedCheck(value, name);
        }

        public void doGetProjects(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ProjectsUpdater(req, rsp).update();
        }
    }
}

