/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.tracker;

import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FileStorageApp;
import com.collabnet.ce.webservices.TrackerApp;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.axis.utils.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNTracker
extends Notifier {
    private static int DEFAULT_PRIORITY = 3;
    private transient BuildListener listener = null;
    private boolean override_auth = true;
    private String username = null;
    private String password = null;
    private String collabNetUrl = null;
    private String project = null;
    private String tracker = null;
    private String title = null;
    private String assign_user = null;
    private int priority = DEFAULT_PRIORITY;
    private boolean attach_log = true;
    private boolean always_update = false;
    private boolean close_issue = true;
    private String release;
    private transient CollabNetApp cna = null;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;

    public CNTracker(String username, String password, String collabNetUrl, String project, String tracker, String title, String assign_user, String priority, boolean attach_log, boolean always_update, boolean close_issue, String release, boolean override_auth) {
        this.username = username;
        this.password = password;
        this.collabNetUrl = CNHudsonUtil.sanitizeCollabNetUrl(collabNetUrl);
        this.project = project;
        this.tracker = tracker;
        this.title = title;
        this.assign_user = assign_user;
        this.priority = Integer.parseInt(priority);
        this.attach_log = attach_log;
        this.always_update = always_update;
        this.close_issue = close_issue;
        this.release = release;
        this.override_auth = override_auth;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            message = "CollabNet Tracker: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        this.log(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return CNTracker.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password;
        }
        return CNTracker.getTeamForgeShareDescriptor().getPassword();
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.collabNetUrl;
        }
        return CNTracker.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getProject() {
        return this.project;
    }

    public String getTracker() {
        return this.tracker;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAssignUser() {
        if (this.assign_user == null || this.assign_user.equals("")) {
            return null;
        }
        return this.assign_user;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean attachLog() {
        return this.attach_log;
    }

    public boolean alwaysUpdate() {
        return this.always_update;
    }

    public boolean closeOnSuccess() {
        return this.close_issue;
    }

    public String getRelease() {
        return this.release;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        Collection<String> projects = ComboBoxUpdater.ProjectsUpdater.getProjectList(cna);
        CNHudsonUtil.logoff(cna);
        return projects.toArray(new String[0]);
    }

    public String[] getTrackers() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        String projectId = this.getProjectId(this.getProject());
        Collection<String> trackers = ComboBoxUpdater.TrackersUpdater.getTrackerList(cna, projectId);
        CNHudsonUtil.logoff(cna);
        return trackers.toArray(new String[0]);
    }

    public String[] getUsers() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        String projectId = this.getProjectId(this.getProject());
        Collection<String> users = ComboBoxUpdater.UsersUpdater.getUserList(cna, projectId);
        CNHudsonUtil.logoff(cna);
        return users.toArray(new String[0]);
    }

    public String[] getReleases() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        String projectId = this.getProjectId(this.getProject());
        Collection<String> releases = ComboBoxUpdater.ReleasesUpdater.getProjectReleaseList(cna, projectId);
        CNHudsonUtil.logoff(cna);
        return releases.toArray(new String[0]);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.setupLogging(listener);
        this.cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        if (this.cna == null) {
            this.log("Critical Error: login to " + this.collabNetUrl + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            return false;
        }
        String projectId = this.getProjectId(this.project);
        if (projectId == null) {
            this.log("Critical Error: projectId cannot be found for " + this.project + ".  This could mean that the project " + "does not exist OR that the user logging in does not " + "have access to that project.  " + "Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            this.logoff();
            return false;
        }
        String trackerId = this.getTrackerId(projectId, this.tracker);
        if (trackerId == null) {
            this.log("Critical Error: trackerId cannot be found for " + this.tracker + ".  This could mean the tracker does " + "not exist OR that the user logging in does not have " + "access to that tracker.  " + "Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            this.logoff();
            return false;
        }
        ArtifactSoapDO issue = this.findTrackerArtifact(trackerId, build);
        Result buildStatus = build.getResult();
        if (issue == null && buildStatus.isWorseThan(Result.SUCCESS)) {
            this.log("Build is not successful; opening a new issue.");
            String description = "The build has failed.  Latest build status: " + build.getResult() + ".  For more info, " + "see " + this.getBuildUrl(build);
            this.createNewTrackerArtifact(projectId, trackerId, "Open", description, build);
        } else if (issue == null && buildStatus.isBetterOrEqualTo(Result.SUCCESS)) {
            this.log("Build is successful!");
            if (this.alwaysUpdate()) {
                String description = "The build has succeeded.  For more info, see " + this.getBuildUrl(build);
                this.createNewTrackerArtifact(projectId, trackerId, "Closed", description, build);
            }
        } else if (issue.getStatusClass().equals("Open") && buildStatus.isWorseThan(Result.SUCCESS)) {
            this.log("Build is continuing to fail; updating issue.");
            this.updateFailingBuild(issue, build);
        } else if (issue.getStatusClass().equals("Open") && buildStatus.isBetterOrEqualTo(Result.SUCCESS)) {
            if (this.closeOnSuccess()) {
                this.log("Build succeeded; closing issue.");
                this.closeSucceedingBuild(issue, build);
            } else {
                this.log("Build succeeded; updating issue.");
                this.updateSucceedingBuild(issue, build);
            }
        } else if (issue.getStatusClass().equals("Close") && buildStatus.isWorseThan(Result.SUCCESS)) {
            if (this.alwaysUpdate()) {
                this.log("Build is not successful; re-opening issue.");
                this.updateFailingBuild(issue, build);
            } else {
                this.log("Build is not successful; opening a new issue.");
                String description = "The build has failed.  Latest build status: " + build.getResult() + ".  For more " + "info, see " + this.getBuildUrl(build);
                this.createNewTrackerArtifact(projectId, trackerId, "Open", description, build);
            }
        } else if (issue.getStatusClass().equals("Close") && buildStatus.isBetterOrEqualTo(Result.SUCCESS)) {
            this.log("Build continues to be successful!");
            if (this.alwaysUpdate()) {
                this.updateSucceedingBuild(issue, build);
            }
        } else {
            this.log("Unexpected state:  result is: " + buildStatus + ".  Issue status " + "class is: " + issue.getStatusClass() + ".");
        }
        this.logoff();
        return true;
    }

    public void logoff() {
        CNHudsonUtil.logoff(this.cna);
        this.cna = null;
    }

    public String getProjectId(String projectName) {
        if (this.cna == null) {
            this.log("Cannot getProjectId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getProjectId(this.cna, projectName);
    }

    public String getTrackerId(String projectId, String trackerName) {
        if (this.cna == null) {
            this.log("Cannot call getTrackerId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getTrackerId(this.cna, projectId, trackerName);
    }

    public ArtifactSoapDO findTrackerArtifact(String trackerId, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call findTrackerArtifact, not logged in!");
            return null;
        }
        String title = this.getInterpreted(build, this.getTitle());
        TrackerApp ta = new TrackerApp(this.cna);
        ArtifactSoapDO asd = null;
        try {
            asd = ta.findLastTrackerArtifact(trackerId, title);
        }
        catch (RemoteException re) {
            this.log("findTrackerArtifact", re);
            return null;
        }
        return asd;
    }

    public ArtifactSoapDO createNewTrackerArtifact(String projectId, String trackerId, String status, String description, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call createNewTrackerArtifact, not logged in!");
            return null;
        }
        ArtifactSoapDO asd = null;
        String buildLogId = null;
        if (this.attachLog()) {
            buildLogId = this.uploadBuildLog(build);
            if (buildLogId != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String assignTo = this.getValidAssignUser(projectId);
        String title = this.getInterpreted(build, this.getTitle());
        String releaseId = CNHudsonUtil.getProjectReleaseId(this.cna, projectId, this.getRelease());
        TrackerApp ta = new TrackerApp(this.cna);
        try {
            asd = ta.createNewTrackerArtifact(trackerId, title, description, null, null, status, null, this.priority, 0, assignTo, releaseId, null, build.getLogFile().getName(), "text/plain", buildLogId);
            this.log("Created tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + this.getArtifactUrl(asd) + ".");
        }
        catch (RemoteException re) {
            this.log("createNewTrackerArtifact", re);
            return null;
        }
        return asd;
    }

    private String getValidAssignUser(String projectId) {
        String valid_user = this.assign_user;
        if (!CNHudsonUtil.isUserMember(this.cna, this.assign_user, projectId)) {
            this.log("User (" + this.assign_user + ") is not a member of " + "the project (" + this.project + ").  " + "Instead " + "any new issues filed will be assigned to 'None'.");
            valid_user = null;
        }
        return valid_user;
    }

    public void updateFailingBuild(ArtifactSoapDO issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateFailingBuild, not logged in!");
            return;
        }
        String buildLogId = null;
        if (this.attachLog()) {
            buildLogId = this.uploadBuildLog(build);
            if (buildLogId != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String update = "Updated";
        if (!issue.getStatus().equals("Open")) {
            issue.setStatus("Open");
            update = "Updated and reopened";
        }
        String comment = "The build is continuing to fail.  Latest build status: " + build.getResult() + ".  For more info, see " + this.getBuildUrl(build);
        String title = this.getInterpreted(build, this.getTitle());
        TrackerApp ta = new TrackerApp(this.cna);
        try {
            ta.setArtifactData(issue, comment, build.getLogFile().getName(), "text/plain", buildLogId);
            this.log(update + " tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + this.getArtifactUrl(issue) + " with failed status.");
        }
        catch (RemoteException re) {
            this.log("updateFailingBuild", re);
        }
        catch (IOException ioe) {
            this.log("updateFailingBuild failed due to IOException:" + ioe.getMessage());
        }
    }

    public void updateSucceedingBuild(ArtifactSoapDO issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return;
        }
        String buildLogId = null;
        if (this.attachLog()) {
            buildLogId = this.uploadBuildLog(build);
            if (buildLogId != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String comment = "The build is succeeding.  For more info, see " + this.getBuildUrl(build);
        String title = this.getInterpreted(build, this.getTitle());
        TrackerApp ta = new TrackerApp(this.cna);
        try {
            ta.setArtifactData(issue, comment, build.getLogFile().getName(), "text/plain", buildLogId);
            this.log("Updated tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + this.getArtifactUrl(issue) + " with successful status.");
        }
        catch (RemoteException re) {
            this.log("updateSucceedingBuild", re);
        }
        catch (IOException ioe) {
            this.log("updateSuccedingBuild failed due to IOException:" + ioe.getMessage());
        }
    }

    public void closeSucceedingBuild(ArtifactSoapDO issue, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return;
        }
        String buildLogId = null;
        if (this.attachLog()) {
            buildLogId = this.uploadBuildLog(build);
            if (buildLogId != null) {
                this.log("Successfully uploaded build log.");
            } else {
                this.log("Failed to upload build log.");
            }
        }
        String comment = "The build succeeded!  Closing issue.  For more info, see " + this.getBuildUrl(build);
        issue.setStatusClass("Close");
        issue.setStatus("Closed");
        String title = this.getInterpreted(build, this.getTitle());
        TrackerApp ta = new TrackerApp(this.cna);
        try {
            ta.setArtifactData(issue, comment, build.getLogFile().getName(), "text/plain", buildLogId);
            this.log("Closed tracker artifact '" + title + "' in tracker '" + this.getTracker() + "' in project '" + this.getProject() + "' on behalf of '" + this.getUsername() + "' at " + this.getArtifactUrl(issue) + " with successful status.");
        }
        catch (RemoteException re) {
            this.log("closeSucceedingBuild", re);
        }
    }

    private String getBuildUrl(AbstractBuild<?, ?> build) {
        Hudson hudson = Hudson.getInstance();
        String rootUrl = hudson.getRootUrl();
        if (rootUrl == null) {
            return "Hudson Build #" + build.number;
        }
        return hudson.getRootUrl() + build.getUrl();
    }

    private String getArtifactUrl(ArtifactSoapDO art) {
        return this.getCollabNetUrl() + "/sf/go/" + art.getId();
    }

    private String uploadBuildLog(AbstractBuild<?, ?> build) {
        if (this.cna == null) {
            this.log("Cannot call updateSucceedingBuild, not logged in!");
            return null;
        }
        String id = null;
        FileStorageApp sfsa = new FileStorageApp(this.cna);
        try {
            id = sfsa.uploadFile(build.getLogFile());
        }
        catch (RemoteException re) {
            this.log("uploadBuildLog", re);
        }
        return id;
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        try {
            return CommonUtil.getInterpreted((Map<String, String>)build.getEnvironment(TaskListener.NULL), str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static Logger log = Logger.getLogger("CNTrackerDescriptor");
        private static int smUniqueIdCounter = 0;

        public DescriptorImpl() {
            super(CNTracker.class);
        }

        public synchronized int getUniqueId() {
            int returnVal;
            block0: {
                if ((returnVal = smUniqueIdCounter++) != 0x7FFFFFFE) break block0;
                smUniqueIdCounter = 0;
            }
            return returnVal;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "CollabNet Tracker";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/tracker/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-main.html";
        }

        public boolean canInheritAuth() {
            return CNTracker.getTeamForgeShareDescriptor().useGlobal();
        }

        public CNTracker newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            boolean override_auth = false;
            String username = null;
            String password = null;
            String collabneturl = null;
            if (formData.has("override_auth")) {
                override_auth = true;
                Object authObject = formData.get("override_auth");
                if (authObject instanceof JSONObject) {
                    username = (String)((JSONObject)authObject).get("username");
                    password = (String)((JSONObject)authObject).get("password");
                    collabneturl = (String)((JSONObject)authObject).get("collabneturl");
                } else if (authObject.equals(Boolean.TRUE)) {
                    username = (String)formData.get("username");
                    password = (String)formData.get("password");
                    collabneturl = (String)formData.get("collabneturl");
                } else {
                    override_auth = false;
                }
            } else if (!this.canInheritAuth()) {
                override_auth = true;
                username = (String)formData.get("username");
                password = (String)formData.get("password");
                collabneturl = (String)formData.get("collabneturl");
            }
            return new CNTracker(username, password, collabneturl, (String)formData.get("project"), (String)formData.get("tracker"), StringUtils.strip((String)((String)formData.get("title"))), StringUtils.strip((String)((String)formData.get("assign_user"))), (String)formData.get("priority"), CommonUtil.getBoolean("attach_log", formData), CommonUtil.getBoolean("always_update", formData), CommonUtil.getBoolean("close_issue", formData), StringUtils.strip((String)((String)formData.get("release"))), override_auth);
        }

        public FormValidation doCollabNetUrlCheck(@QueryParameter String value) {
            return CNFormFieldValidator.soapUrlCheck(value);
        }

        public FormValidation doPasswordCheck(StaplerRequest req) {
            return CNFormFieldValidator.loginCheck(req);
        }

        public FormValidation doProjectCheck(StaplerRequest req) {
            return CNFormFieldValidator.projectCheck(req);
        }

        public FormValidation doTrackerCheck(StaplerRequest req) {
            return CNFormFieldValidator.trackerCheck(req);
        }

        public FormValidation doAssignCheck(StaplerRequest req) {
            return CNFormFieldValidator.assignCheck(req);
        }

        public FormValidation doRequiredCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredCheck(value, name);
        }

        public FormValidation doRequiredInterpretedCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredInterpretedCheck(value, name);
        }

        public FormValidation doReleaseCheck(StaplerRequest req) {
            return CNFormFieldValidator.releaseCheck(req);
        }

        public void doGetProjects(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ProjectsUpdater(req, rsp).update();
        }

        public void doGetTrackers(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.TrackersUpdater(req, rsp).update();
        }

        public void doGetProjectUsers(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.UsersUpdater(req, rsp).update();
        }

        public void doGetReleases(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ReleasesUpdater(req, rsp).update();
        }
    }
}

