/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.soap50.webservices.scm.Repository2SoapDO;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FrsApp;
import com.collabnet.ce.webservices.ScmApp;
import com.collabnet.ce.webservices.TrackerApp;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CommonUtil;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

public class CNHudsonUtil {
    private static Logger log = Logger.getLogger("CNHudsonUtil");

    private CNHudsonUtil() {
    }

    public static CollabNetApp getCollabNetApp(String url, String username, String password) {
        if (CommonUtil.unset(url)) {
            return null;
        }
        try {
            return new CollabNetApp(url, username, password);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getCollabNetApp", re);
            log.log(Level.SEVERE, "getCollabNetApp failed", re);
            return null;
        }
    }

    public static CollabNetApp getCollabNetApp(StaplerRequest request) {
        String url = null;
        String username = null;
        String password = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        if (descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false")) {
            url = descriptor.getCollabNetUrl();
            username = descriptor.getUsername();
            password = descriptor.getPassword();
        } else {
            url = request.getParameter("url");
            username = request.getParameter("username");
            password = request.getParameter("password");
        }
        if (CommonUtil.unset(url) || CommonUtil.unset(username) || CommonUtil.unset(password)) {
            return null;
        }
        return CNHudsonUtil.getCollabNetApp(url, username, password);
    }

    public static String getUsername(StaplerRequest request) {
        String username = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        username = descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false") ? descriptor.getUsername() : request.getParameter("username");
        return username;
    }

    public static void logoff(CollabNetApp cna) {
        if (cna != null) {
            try {
                cna.logoff();
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "logoff", re);
            }
        }
    }

    public static String getPackageId(CollabNetApp cna, String rpackage, String projectId) {
        String packageId = null;
        if (cna != null && projectId != null) {
            FrsApp fa = new FrsApp(cna);
            try {
                packageId = fa.findPackageId(rpackage, projectId);
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "getPackageId", re);
                return null;
            }
        }
        return packageId;
    }

    public static String getProjectId(CollabNetApp cna, String project) {
        String projectId = null;
        if (cna != null) {
            try {
                projectId = cna.getProjectId(project);
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "getProjectId", re);
            }
        }
        return projectId;
    }

    public static String getReleaseId(CollabNetApp cna, String packageId, String release) {
        if (cna == null || packageId == null) {
            return null;
        }
        String releaseId = null;
        FrsApp fa = new FrsApp(cna);
        try {
            releaseId = fa.findReleaseIdByPackage(release, packageId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getReleaseId", re);
        }
        return releaseId;
    }

    public static String getFileId(CollabNetApp cna, String releaseId, String file) {
        if (cna == null || releaseId == null) {
            return null;
        }
        String fileId = null;
        FrsApp fa = new FrsApp(cna);
        try {
            fileId = fa.findFrsFile(file, releaseId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getFileId", re);
        }
        return fileId;
    }

    public static String getProjectReleaseId(CollabNetApp cna, String projectId, String release) {
        if (cna == null || projectId == null) {
            return null;
        }
        FrsApp fa = new FrsApp(cna);
        String releaseId = null;
        try {
            releaseId = fa.findReleaseId(release, projectId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getProjectReleaseId", re);
        }
        return releaseId;
    }

    public static String getTrackerId(CollabNetApp cna, String projectId, String trackerName) {
        if (cna == null || projectId == null) {
            return null;
        }
        TrackerApp ta = new TrackerApp(cna);
        String trackerId = null;
        try {
            trackerId = ta.getTrackerId(projectId, trackerName);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getTrackerId", re);
            return null;
        }
        return trackerId;
    }

    public static ArtifactSoapDO getTrackerArtifact(CollabNetApp cna, String project, String tracker, String issueTitle) {
        String trackerId;
        String projectId;
        ArtifactSoapDO artifact = null;
        if (cna != null && (projectId = CNHudsonUtil.getProjectId(cna, project)) != null && (trackerId = CNHudsonUtil.getTrackerId(cna, projectId, tracker)) != null) {
            TrackerApp ta = new TrackerApp(cna);
            try {
                artifact = ta.findLastTrackerArtifact(trackerId, issueTitle);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        return artifact;
    }

    public static String getFileId(CollabNetApp cna, String project, String rpackage, String release, String file) {
        String releaseId;
        String packageId;
        String fileId = null;
        String projectId = CNHudsonUtil.getProjectId(cna, project);
        if (projectId != null && (packageId = CNHudsonUtil.getPackageId(cna, rpackage, projectId)) != null && (releaseId = CNHudsonUtil.getReleaseId(cna, packageId, release)) != null) {
            fileId = CNHudsonUtil.getFileId(cna, releaseId, file);
        }
        return fileId;
    }

    public static boolean isUserValid(CollabNetApp cna, String username) {
        boolean valid = false;
        try {
            valid = cna.isUsernameValid(username);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "userExists", re);
        }
        return valid;
    }

    public static boolean isUserMember(CollabNetApp cna, String username, String projectId) {
        boolean member = false;
        try {
            member = cna.isUserMemberOfProject(username, projectId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "userMember", re);
        }
        return member;
    }

    public static String getScmViewerUrl(CollabNetApp cna, String collabnetUrl, String projectName, String repoName) {
        String url = null;
        Repository2SoapDO repoData = CNHudsonUtil.getRepoData(cna, projectName, repoName);
        if (repoData != null) {
            url = repoData.getScmViewerUrl();
            if (cna != null) {
                int[] apiVersion = null;
                try {
                    apiVersion = CNHudsonUtil.getVersionArray(cna.getApiVersion());
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getScmViewerUrl", re);
                }
                if (CNHudsonUtil.isSupportedVersion(new int[]{5, 3, 0, 0}, new int[]{6, 0, 0, 0}, apiVersion)) {
                    url = collabnetUrl + "/sf/scm/do/viewRepositorySource/" + repoData.getPath();
                }
            }
        }
        return url;
    }

    public static int[] getVersionArray(String apiVersionStr) {
        int[] versionNums = null;
        if (apiVersionStr != null) {
            String[] versionArr = apiVersionStr.split("\\.");
            versionNums = new int[versionArr.length];
            for (int i = 0; i < versionArr.length; ++i) {
                versionNums[i] = Integer.parseInt(versionArr[i]);
            }
        }
        return versionNums;
    }

    public static boolean isSupportedVersion(int[] startSupportVersion, int[] endSupportVersion, int[] actualVersion) {
        if (actualVersion == null || actualVersion.length != 4) {
            log.warning("Unable to determine api version: isSupportedVersion returning false");
            return false;
        }
        if (startSupportVersion != null) {
            if (startSupportVersion.length != 4) {
                return false;
            }
            if (CNHudsonUtil.compareVersion(actualVersion, startSupportVersion) == -1) {
                return false;
            }
        }
        if (endSupportVersion != null) {
            if (endSupportVersion.length != 4) {
                return false;
            }
            if (CNHudsonUtil.compareVersion(actualVersion, endSupportVersion) != -1) {
                return false;
            }
        }
        return true;
    }

    public static int compareVersion(int[] version1, int[] version2) {
        for (int i = 0; i < version1.length; ++i) {
            int v1 = version1[i];
            int v2 = version2[i];
            if (v1 > v2) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        return 0;
    }

    public static String getSystemId(CollabNetApp cna, String projectName, String repoName) {
        String systemId = null;
        Repository2SoapDO repoData = CNHudsonUtil.getRepoData(cna, projectName, repoName);
        if (repoData != null) {
            systemId = repoData.getSystemId();
        }
        return systemId;
    }

    private static Repository2SoapDO getRepoData(CollabNetApp cna, String projectName, String repoName) {
        Repository2SoapDO repoData = null;
        String projectId = CNHudsonUtil.getProjectId(cna, projectName);
        if (projectId == null) {
            return null;
        }
        String repoId = CNHudsonUtil.getRepoId(cna, projectId, repoName);
        if (repoId == null) {
            return null;
        }
        ScmApp sa = new ScmApp(cna);
        try {
            repoData = sa.getRepoData(repoId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getScmViewerUrl", re);
        }
        return repoData;
    }

    public static String getRepoId(CollabNetApp cna, String projectId, String repoName) {
        String repoId = null;
        ScmApp sa = new ScmApp(cna);
        try {
            repoId = sa.getRepoId(projectId, repoName);
        }
        catch (RemoteException re) {
            CommonUtil.logRE(log, "getRepoId", re);
        }
        return repoId;
    }

    public static String sanitizeCollabNetUrl(String url) {
        if (url != null && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

