/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FrsApp;
import com.collabnet.ce.webservices.ScmApp;
import com.collabnet.ce.webservices.TrackerApp;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboBoxUpdater {
    protected static Logger log = Logger.getLogger("ComboBoxUpdater");
    protected final StaplerRequest request;
    protected final StaplerResponse response;

    protected ComboBoxUpdater(StaplerRequest req, StaplerResponse rsp) {
        this.request = req;
        this.response = rsp;
    }

    protected abstract Collection<String> getList();

    public void update() throws IOException {
        Collection<String> list = this.getList();
        this.response.setContentType("text/plain;charset=UTF-8");
        JSONObject jsonObj = new JSONObject();
        jsonObj.element("items", list);
        this.response.getWriter().print(jsonObj.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UsersUpdater
    extends ComboBoxUpdater {
        public UsersUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String project = this.request.getParameter("project");
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            Collection<String> list = UsersUpdater.getUserList(cna, projectId);
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getUserList(CollabNetApp cna, String projectId) {
            Collection<String> users = Collections.emptyList();
            if (cna != null && projectId != null) {
                try {
                    users = cna.getUsers(projectId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getUserList", re);
                }
            }
            return CommonUtil.sanitizeForJS(users);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrackersUpdater
    extends ComboBoxUpdater {
        public TrackersUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String project = this.request.getParameter("project");
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            Collection<String> list = TrackersUpdater.getTrackerList(cna, projectId);
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getTrackerList(CollabNetApp cna, String projectId) {
            Collection<String> trackers = Collections.emptyList();
            if (cna != null && projectId != null) {
                TrackerApp ta = new TrackerApp(cna);
                try {
                    trackers = ta.getTrackers(projectId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getTrackerList", re);
                }
            }
            return CommonUtil.sanitizeForJS(trackers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReposUpdater
    extends ComboBoxUpdater {
        public ReposUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String project = this.request.getParameter("project");
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            Collection<String> list = ReposUpdater.getRepoList(cna, projectId);
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getRepoList(CollabNetApp cna, String projectId) {
            Collection<String> repos = Collections.emptyList();
            if (cna != null) {
                ScmApp sa = new ScmApp(cna);
                try {
                    repos = sa.getRepos(projectId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getRepoList", re);
                }
            }
            return CommonUtil.sanitizeForJS(repos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReleasesUpdater
    extends ComboBoxUpdater {
        public ReleasesUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String project = this.request.getParameter("project");
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            String rpackage = this.request.getParameter("package");
            Collection<Object> list = Collections.emptyList();
            if (CommonUtil.unset(rpackage)) {
                list = ReleasesUpdater.getProjectReleaseList(cna, projectId);
            } else {
                String packageId = CNHudsonUtil.getPackageId(cna, rpackage, projectId);
                list = ReleasesUpdater.getReleaseList(cna, packageId);
            }
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getReleaseList(CollabNetApp cna, String packageId) {
            Collection<String> releases = Collections.emptyList();
            if (cna != null && packageId != null) {
                FrsApp fa = new FrsApp(cna);
                try {
                    releases = fa.getReleases(packageId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getReleaseList", re);
                }
            }
            return CommonUtil.sanitizeForJS(releases);
        }

        public static Collection<String> getProjectReleaseList(CollabNetApp cna, String projectId) {
            Collection<String> releases = Collections.emptyList();
            if (cna != null && projectId != null) {
                FrsApp fa = new FrsApp(cna);
                try {
                    releases = fa.getProjectReleases(projectId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getProjectReleaseList", re);
                }
            }
            return CommonUtil.sanitizeForJS(releases);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackagesUpdater
    extends ComboBoxUpdater {
        public PackagesUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String project = this.request.getParameter("project");
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            Collection<String> list = PackagesUpdater.getPackageList(cna, projectId);
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getPackageList(CollabNetApp cna, String projectId) {
            Collection<String> packages = Collections.emptyList();
            if (cna != null && projectId != null) {
                FrsApp fa = new FrsApp(cna);
                try {
                    packages = fa.getPackages(projectId);
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getPackageList", re);
                }
            }
            return CommonUtil.sanitizeForJS(packages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectsUpdater
    extends ComboBoxUpdater {
        public ProjectsUpdater(StaplerRequest req, StaplerResponse rsp) {
            super(req, rsp);
        }

        @Override
        protected Collection<String> getList() {
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            Collection<String> list = ProjectsUpdater.getProjectList(cna);
            CNHudsonUtil.logoff(cna);
            return list;
        }

        public static Collection<String> getProjectList(CollabNetApp cna) {
            Collection<String> projects = Collections.emptyList();
            if (cna != null) {
                try {
                    projects = cna.getProjects();
                }
                catch (RemoteException re) {
                    CommonUtil.logRE(log, "getProjectList", re);
                }
            }
            return CommonUtil.sanitizeForJS(projects);
        }
    }
}

