/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthProjectProperty
extends JobProperty<Job<?, ?>> {
    public static Permission CONFIGURE_PROPERTY = Item.CONFIGURE;
    private transient boolean mIsNotLoadedFromDisk = false;
    private transient String project = null;
    private String projectId = null;
    private boolean createRoles = false;
    private boolean grantDefaultRoles = false;
    private static Logger log = Logger.getLogger("CNAuthProjectProperty");
    private static Collection<String> defaultAdminRoles = Collections.emptyList();
    private static Collection<String> defaultUserRoles = Collections.emptyList();

    public CNAuthProjectProperty(String projectName, Boolean createRoles, Boolean grantDefaults, boolean isNotLoadedFromDisk) {
        this.project = projectName;
        this.createRoles = createRoles;
        this.grantDefaultRoles = grantDefaults;
        if (this.createRoles || this.grantDefaultRoles) {
            this.loadRoles();
        }
        this.mIsNotLoadedFromDisk = isNotLoadedFromDisk;
    }

    private void loadProjectIdIfNecessary() {
        if (CommonUtil.isEmpty((String)this.projectId) && !CommonUtil.isEmpty((String)this.project)) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return;
            }
            this.projectId = conn.getProjectId(this.project);
            if (!this.mIsNotLoadedFromDisk && this.owner != null) {
                try {
                    this.mIsNotLoadedFromDisk = true;
                    this.owner.save();
                }
                catch (IOException e) {
                    log.info("Failed to modify config file for migration of project name to project id");
                }
            }
        }
    }

    public String getProject() {
        CNConnection conn;
        this.loadProjectIdIfNecessary();
        if (!CommonUtil.isEmpty((String)this.projectId) && (conn = CNConnection.getInstance()) != null) {
            return conn.getProjectName(this.projectId);
        }
        return "";
    }

    public String getProjectId() {
        this.loadProjectIdIfNecessary();
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean createRoles() {
        return this.createRoles;
    }

    public boolean grantDefaultRoles() {
        return this.grantDefaultRoles;
    }

    public Collection<String> getDefaultUserRoles() {
        if (defaultUserRoles.isEmpty()) {
            defaultUserRoles = new ArrayList();
            defaultUserRoles.add("Hudson Read");
        }
        return defaultUserRoles;
    }

    public Collection<String> getDefaultAdminRoles() {
        if (defaultAdminRoles.isEmpty()) {
            defaultAdminRoles = CNProjectACL.CollabNetRoles.getNames();
        }
        return defaultAdminRoles;
    }

    private void loadRoles() {
        String projectIdStr = this.getProjectId();
        if (!CommonUtil.isEmpty((String)projectIdStr)) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                log.warning("Cannot loadRoles, incorrect authentication type.");
                return;
            }
            if (this.createRoles()) {
                ArrayList<String> roleNames = new ArrayList<String>();
                ArrayList<String> descriptions = new ArrayList<String>();
                for (CollabNetRole role : CNProjectACL.CollabNetRoles.getAllRoles()) {
                    roleNames.add(role.getName());
                    descriptions.add(role.getDescription());
                }
                conn.addRoles(projectIdStr, roleNames, descriptions);
            }
            if (this.grantDefaultRoles()) {
                conn.grantRoles(projectIdStr, this.getDefaultUserRoles(), conn.getUsers(projectIdStr));
                conn.grantRoles(projectIdStr, this.getDefaultAdminRoles(), conn.getAdmins(projectIdStr));
            }
        }
    }

    static /* synthetic */ void access$000(CNAuthProjectProperty x0) {
        x0.loadProjectIdIfNecessary();
    }
}

