/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthorizationStrategy;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthorizationCache {
    private Map<String, Set<Permission>> mPermSetMap = new HashMap();
    private long mCacheExpirationDate = System.currentTimeMillis();

    private void clearCache() {
        this.mPermSetMap.clear();
        AuthorizationStrategy authStrategy = Hudson.getInstance().getAuthorizationStrategy();
        CNAuthorizationStrategy cnAuthStrategy = (CNAuthorizationStrategy)authStrategy;
        long permCacheTimeoutMs = cnAuthStrategy.getAuthCacheTimeoutMs();
        this.mCacheExpirationDate = System.currentTimeMillis() + permCacheTimeoutMs;
    }

    public synchronized Set<Permission> getUserProjectPermSet(String username, String projectId) {
        String cacheKey;
        HashSet userPermSet;
        if (System.currentTimeMillis() >= this.mCacheExpirationDate) {
            this.clearCache();
        }
        if ((userPermSet = (HashSet)this.mPermSetMap.get(cacheKey = projectId + ":" + username)) == null) {
            CNConnection conn = CNConnection.getInstance();
            HashSet roleNameSet = new HashSet(conn.getUserRoles(projectId, username));
            Collection userRoles = CNProjectACL.CollabNetRoles.getMatchingRoles(roleNameSet);
            userPermSet = new HashSet();
            for (CollabNetRole role : userRoles) {
                userPermSet.addAll(role.getPermissions());
            }
            this.mPermSetMap.put(cacheKey, userPermSet);
        }
        return userPermSet;
    }
}

