/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CollabNetSecurityRealm;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CNFilter
implements Filter {
    private static Logger log = Logger.getLogger("CNFilter");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecurityRealm securityRealm;
        if (Hudson.getInstance().isUseSecurity() && (securityRealm = Hudson.getInstance().getSecurityRealm()) instanceof CollabNetSecurityRealm) {
            CNAuthentication cnauth;
            CollabNetSecurityRealm cnRealm = (CollabNetSecurityRealm)securityRealm;
            boolean enableSSOFromCTF = cnRealm.getEnableSSOAuthFromCTF();
            boolean enableSSOToCTF = cnRealm.getEnableSSOAuthToCTF();
            Authentication auth = Hudson.getAuthentication();
            if (enableSSOFromCTF) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String username = request.getParameter("sfUsername");
                if (username != null && !username.equals(auth.getName())) {
                    auth.setAuthenticated(false);
                }
                if (!auth.isAuthenticated() || auth.getPrincipal().equals("anonymous")) {
                    this.loginHudsonUsingCTFSSO((CollabNetSecurityRealm)securityRealm, httpRequest);
                }
            }
            if (enableSSOToCTF && auth instanceof CNAuthentication && !(cnauth = (CNAuthentication)auth).isCNAuthed()) {
                this.loginToCTF(cnauth, (CollabNetSecurityRealm)securityRealm, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void loginHudsonUsingCTFSSO(CollabNetSecurityRealm securityRealm, HttpServletRequest request) {
        String url = securityRealm.getCollabNetUrl();
        String username = request.getParameter("sfUsername");
        String token = request.getParameter("sfLoginToken");
        CNAuthentication auth = null;
        boolean logoff = false;
        if (username != null && token != null) {
            CollabNetApp ca = new CollabNetApp(url, username);
            try {
                ca.loginWithToken(token);
                auth = new CNAuthentication((Object)username, (Object)ca);
            }
            catch (RemoteException re) {
                log.severe("Login failed with RemoteException: " + re.getMessage());
                logoff = true;
            }
        } else {
            logoff = true;
        }
        if (logoff) {
            auth = new AnonymousAuthenticationToken("anonymous", (Object)"anonymous", new GrantedAuthority[]{new GrantedAuthorityImpl("anonymous")});
        }
        request.getSession(true);
        SecurityContextHolder.getContext().setAuthentication(auth);
    }

    private void loginToCTF(CNAuthentication cnauth, CollabNetSecurityRealm securityRealm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        cnauth.setCNAuthed(true);
        String reqUrl = CNFilter.getCurrentUrl((HttpServletRequest)request);
        String collabNetUrl = securityRealm.getCollabNetUrl();
        String username = (String)cnauth.getPrincipal();
        String id = cnauth.getSessionId();
        String cnauthUrl = collabNetUrl + "/sf/sfmain/do/soapredirect?id=" + URLEncoder.encode(id, "UTF-8") + "&user=" + URLEncoder.encode(username, "UTF-8");
        if (securityRealm.getEnableSSORedirect()) {
            cnauthUrl = cnauthUrl + "&redirectUrl=" + URLEncoder.encode(reqUrl, "UTF-8");
        }
        response.setStatus(302);
        response.setHeader("Location", cnauthUrl);
    }

    public static String getCurrentBaseUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder();
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            url.append(rootUrl);
        } else {
            url.append(req.getScheme());
            url.append("://");
            url.append(req.getServerName());
            if (req.getServerPort() != 80) {
                url.append(':').append(req.getServerPort());
            }
            url.append(req.getContextPath());
        }
        return url.toString();
    }

    public static String getCurrentUrl(HttpServletRequest req) {
        String curBaseUrl = CNFilter.getCurrentBaseUrl((HttpServletRequest)req);
        curBaseUrl = CommonUtil.stripSlashes((String)curBaseUrl);
        curBaseUrl = StringUtils.removeEnd((String)curBaseUrl, (String)req.getContextPath());
        StringBuilder url = new StringBuilder(curBaseUrl);
        if (req.getRequestURI() != null) {
            url.append(req.getRequestURI());
        }
        if (req.getQueryString() != null) {
            url.append("?" + req.getQueryString());
        }
        return url.toString();
    }

    public void destroy() {
    }
}

