/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Set;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;

public class CNProjectACL
extends ACL {
    private String projectId = null;
    private static Logger log = Logger.getLogger("CNProjectACL");

    public CNProjectACL(String projectId) {
        this.projectId = projectId;
    }

    public boolean hasPermission(Authentication a, Permission permission) {
        if (!(a instanceof CNAuthentication)) {
            log.severe("Improper Authentication type used with CNAuthorizationStrategy!  CNAuthorization strategy cannot be used without CNAuthentication.  Please re-configure your Hudson instance.");
            return false;
        }
        if (CommonUtil.isEmpty((String)this.projectId)) {
            log.severe("hasPerission: project id could not be found for project: " + this.projectId + ".");
            return false;
        }
        CNAuthentication cnAuth = (CNAuthentication)a;
        String username = (String)cnAuth.getPrincipal();
        Set userPerms = cnAuth.getUserProjectPermSet(username, this.projectId);
        while (permission != null) {
            if (userPerms.contains(permission)) {
                return true;
            }
            permission = permission.impliedBy;
        }
        return false;
    }
}

