/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.documentuploader;

import com.collabnet.ce.soap50.webservices.docman.DocumentSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.DocumentApp;
import com.collabnet.ce.webservices.FileStorageApp;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.documentuploader.CNDocumentUploader;
import hudson.plugins.collabnet.documentuploader.CnduResultAction;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CNDocumentUploader
extends Notifier {
    private static Logger logger = Logger.getLogger("CNDocumentUploader");
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private transient BuildListener listener = null;
    private transient CollabNetApp cna = null;
    private boolean override_auth = true;
    private String url;
    private String username;
    private Secret password;
    private String project;
    private String uploadPath;
    private String description;
    private String[] file_patterns;
    private boolean includeBuildLog;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;

    public CNDocumentUploader(String url, String username, String password, String project, String uploadPath, String description, String[] filePatterns, boolean includeBuildLog, boolean override_auth) {
        this.url = CNHudsonUtil.sanitizeCollabNetUrl((String)url);
        this.username = username;
        this.password = Secret.fromString((String)password);
        this.project = project;
        this.uploadPath = uploadPath;
        this.description = description;
        this.file_patterns = filePatterns;
        this.includeBuildLog = includeBuildLog;
        this.override_auth = override_auth;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void logConsole(String message) {
        if (this.listener != null) {
            message = "CollabNet Document Uploader: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void logConsole(String message, Exception exception) {
        if (this.listener != null) {
            message = "CollabNet Document Uploader: " + message;
            this.listener.getLogger().println(message);
            exception.printStackTrace(this.listener.error("error"));
        }
    }

    private void log(String methodName, RemoteException re) {
        CommonUtil.logRE((Logger)logger, (String)methodName, (RemoteException)re);
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.url;
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password == null ? null : this.password.toString();
        }
        return CNDocumentUploader.getTeamForgeShareDescriptor().getPassword();
    }

    public String getProject() {
        return this.project;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new String[0];
    }

    public boolean includeBuildLog() {
        return this.includeBuildLog;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        Collection projects = ComboBoxUpdater.ProjectsUpdater.getProjectList((CollabNetApp)cna);
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return projects.toArray(new String[0]);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.setupLogging(listener);
        this.cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        if (this.cna == null) {
            this.logConsole("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, null));
            return false;
        }
        String projectId = this.getProjectId();
        if (projectId == null) {
            this.logConsole("Critical Error: Unable to find project '" + this.getProject() + "'.  " + "Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, null));
            this.logoff();
            return false;
        }
        DocumentApp da = new DocumentApp(this.cna);
        String folderId = null;
        String path = this.getInterpreted(build, this.getUploadPath());
        try {
            folderId = da.findOrCreatePath(projectId, path);
        }
        catch (RemoteException re) {
            this.log("findOrCreatePath", re);
            this.logConsole("Critical Error: Unable to create a path for '" + path + "'.  Setting build status to " + "UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction(this.createAction(0, folderId));
            this.logoff();
            return false;
        }
        int numUploaded = this.uploadFiles(folderId, build);
        build.addAction(this.createAction(numUploaded, folderId));
        try {
            this.cna.logoff();
        }
        catch (RemoteException re) {
            this.log("logoff", re);
        }
        return true;
    }

    private Action createAction(int numUploaded, String folderId) {
        String displaymsg = "Download from CollabNet Documents";
        return new CnduResultAction(displaymsg, "/plugin/collabnet/images/48x48/cn-icon.gif", "console", this.getFolderUrl(folderId), numUploaded);
    }

    private String getFolderUrl(String folderId) {
        String path = null;
        if (folderId != null) {
            try {
                DocumentApp da = new DocumentApp(this.cna);
                path = da.getFolderPath(folderId);
            }
            catch (RemoteException re) {
                this.log("getFolderUrl", re);
            }
        }
        if (path == null) {
            return this.getCollabNetUrl();
        }
        return this.getCollabNetUrl() + "/sf/docman/do/listDocuments/" + path;
    }

    public int uploadFiles(String folderId, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        int numUploaded = 0;
        String path = this.getInterpreted(build, this.getUploadPath());
        this.logConsole("Uploading files to project '" + this.getProject() + "', folder '" + path + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (String uninterp_fp : this.getFilePatterns()) {
            FilePath[] filePaths;
            String file_pattern = "";
            try {
                file_pattern = this.getInterpreted(build, uninterp_fp);
            }
            catch (IllegalArgumentException e) {
                this.logConsole("File pattern " + uninterp_fp + " contained a bad env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals("")) continue;
            for (FilePath uploadFilePath : filePaths = this.getFilePaths(build, file_pattern)) {
                String fileId = this.uploadFile(uploadFilePath);
                if (fileId == null) {
                    this.logConsole("Failed to upload " + uploadFilePath.getName() + ".");
                    continue;
                }
                String docId = null;
                try {
                    docId = this.updateOrCreateDoc(folderId, fileId, uploadFilePath.getName(), CNDocumentUploader.getMimeType((FilePath)uploadFilePath), build);
                    this.logConsole("Uploaded " + uploadFilePath.getName() + " -> " + this.getDocUrl(docId));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.logConsole("Upload file failed: " + re.getMessage());
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        if (this.includeBuildLog()) {
            String fileId = this.uploadBuildLog(build);
            if (fileId == null) {
                this.logConsole("Failed to upload " + build.getLogFile().getName() + ".");
            } else {
                String docId = null;
                try {
                    docId = this.updateOrCreateDoc(folderId, fileId, build.getLogFile().getName(), CNDocumentUploader.getMimeType((File)build.getLogFile()), build);
                    this.logConsole("Uploaded " + build.getLogFile().getName() + " -> " + this.getDocUrl(docId));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.logConsole("Upload log failed: " + re.getMessage(), (Exception)re);
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        return numUploaded;
    }

    private String getDocUrl(String docId) {
        return this.getCollabNetUrl() + "/sf/go/" + docId;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = FreeStyleProject.class.isInstance(build.getProject()) ? build.getWorkspace() : build.getProject().getRootProject().getWorkspace();
        String logEntry = "Searching ant pattern '" + pattern + "'";
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
            logEntry = logEntry + " in " + workspace.absolutize().getRemote();
        }
        catch (IOException ioe) {
            this.logConsole("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.logConsole("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        logEntry = logEntry + " : found " + uploadFilePaths.length + " entry(ies)";
        this.logConsole(logEntry);
        return uploadFilePaths;
    }

    private String updateOrCreateDoc(String folderId, String fileId, String fileName, String mimeType, AbstractBuild<?, ?> build) throws RemoteException, IOException, InterruptedException {
        DocumentApp da = new DocumentApp(this.cna);
        String docId = da.findDocumentId(folderId, fileName);
        if (docId != null) {
            da.updateDoc(docId, fileId);
        } else {
            DocumentSoapDO document = da.createDocument(folderId, fileName, this.getInterpreted(build, this.getDescription()), null, "final", false, fileName, mimeType, fileId, null, null);
            docId = document.getId();
        }
        return docId;
    }

    public static String getMimeType(FilePath filePath) {
        String mimeType = "text/plain";
        try {
            mimeType = (String)filePath.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return mimeType;
    }

    public static String getMimeType(File f) {
        if (f.getName().endsWith("log")) {
            return "text/plain";
        }
        return new MimetypesFileTypeMap().getContentType(f);
    }

    private String uploadBuildLog(AbstractBuild<?, ?> build) {
        if (this.cna == null) {
            this.logConsole("Cannot call updateSucceedingBuild, not logged in!");
            return null;
        }
        String id = null;
        FileStorageApp sfsa = new FileStorageApp(this.cna);
        try {
            id = sfsa.uploadFile(build.getLogFile());
        }
        catch (RemoteException re) {
            this.log("uploadBuildLog", re);
        }
        return id;
    }

    private String uploadFile(FilePath filePath) {
        if (this.cna == null) {
            this.logConsole("Cannot call uploadFile, not logged in!");
            return null;
        }
        String id = null;
        try {
            id = (String)filePath.act((FilePath.FileCallable)new RemoteFileUploader(this.getCollabNetUrl(), this.getUsername(), this.cna.getSessionId()));
        }
        catch (RemoteException re) {
            this.logConsole("upload file failed", (Exception)re);
        }
        catch (IOException ioe) {
            this.logConsole("Could not upload file due to IOException: " + ioe.getMessage(), (Exception)ioe);
        }
        catch (InterruptedException ie) {
            this.logConsole("Could not upload file due to InterruptedException: " + ie.getMessage());
        }
        return id;
    }

    public void logoff() {
        CNHudsonUtil.logoff((CollabNetApp)this.cna);
        this.cna = null;
    }

    public String getProjectId() {
        if (this.cna == null) {
            this.logConsole("Cannot getProjectId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getProjectId((CollabNetApp)this.cna, (String)this.getProject());
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        try {
            return CommonUtil.getInterpreted((Map)build.getEnvironment(TaskListener.NULL), (String)str);
        }
        catch (IllegalArgumentException iae) {
            this.logConsole(iae.getMessage());
            throw iae;
        }
    }
}

