/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.filestorage.ISimpleFileStorageAppSoap;
import com.collabnet.ce.webservices.AbstractSoapApp;
import com.collabnet.ce.webservices.CollabNetApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;

public class SimpleFileStorageApp
extends AbstractSoapApp {
    private static int BYTE_SIZE = 0x100000;
    private ISimpleFileStorageAppSoap ifsa = this.getISimpleFileStorageAppSoap();

    public SimpleFileStorageApp(CollabNetApp collabNetApp) {
        super(collabNetApp);
    }

    private ISimpleFileStorageAppSoap getISimpleFileStorageAppSoap() {
        String soapURL = this.getServerUrl() + CollabNetApp.SOAP_SERVICE + "SimpleFileStorageApp?wsdl";
        return (ISimpleFileStorageAppSoap)ClientSoapStubFactory.getSoapStub(ISimpleFileStorageAppSoap.class, (String)soapURL);
    }

    public String uploadFile(File file) throws RemoteException {
        String id = null;
        byte[] bytes = new byte[BYTE_SIZE];
        byte[] smallerBytes = null;
        int bytesRead = 0;
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new CollabNetApp.CollabNetAppException("uploadBuildLog failed due to FileNotFoundException: " + fnfe.getMessage());
        }
        try {
            id = this.ifsa.startFileUpload(this.getSessionId());
            while ((bytesRead = istream.read(bytes)) > 0) {
                if (bytesRead == BYTE_SIZE) {
                    this.ifsa.write(this.getSessionId(), id, bytes);
                    continue;
                }
                smallerBytes = new byte[bytesRead];
                System.arraycopy(bytes, 0, smallerBytes, 0, bytesRead);
                this.ifsa.write(this.getSessionId(), id, smallerBytes);
            }
            this.ifsa.endFileUpload(this.getSessionId(), id);
            istream.close();
        }
        catch (IOException ioe) {
            throw new CollabNetApp.CollabNetAppException("uploadBuildLog failed due to IOException: " + ioe.getMessage());
        }
        return id;
    }
}

