/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.collabnet.auth.CNAuthorizationStrategy;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthProjectProperty
extends JobProperty<Job<?, ?>> {
    public static Permission CONFIGURE_PROPERTY = Item.CONFIGURE;
    private transient boolean mIsNotLoadedFromDisk = false;
    private transient String project = null;
    private String projectId = null;
    private boolean createRoles = false;
    private boolean grantDefaultRoles = false;
    private static Logger log = Logger.getLogger("CNAuthProjectProperty");
    private static Collection<String> defaultAdminRoles = Collections.emptyList();
    private static Collection<String> defaultUserRoles = Collections.emptyList();

    public CNAuthProjectProperty(String projectName, Boolean createRoles, Boolean grantDefaults, boolean isNotLoadedFromDisk) {
        this.project = projectName;
        this.createRoles = createRoles;
        this.grantDefaultRoles = grantDefaults;
        if (this.createRoles || this.grantDefaultRoles) {
            this.loadRoles();
        }
        this.mIsNotLoadedFromDisk = isNotLoadedFromDisk;
    }

    private void loadProjectIdIfNecessary() {
        if (CommonUtil.isEmpty(this.projectId) && !CommonUtil.isEmpty(this.project)) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return;
            }
            this.projectId = conn.getProjectId(this.project);
            if (!this.mIsNotLoadedFromDisk && this.owner != null) {
                try {
                    this.mIsNotLoadedFromDisk = true;
                    this.owner.save();
                }
                catch (IOException e) {
                    log.info("Failed to modify config file for migration of project name to project id");
                }
            }
        }
    }

    public String getProject() {
        CNConnection conn;
        this.loadProjectIdIfNecessary();
        if (!CommonUtil.isEmpty(this.projectId) && (conn = CNConnection.getInstance()) != null) {
            return conn.getProjectName(this.projectId);
        }
        return "";
    }

    public String getProjectId() {
        this.loadProjectIdIfNecessary();
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean createRoles() {
        return this.createRoles;
    }

    public boolean grantDefaultRoles() {
        return this.grantDefaultRoles;
    }

    public Collection<String> getDefaultUserRoles() {
        if (defaultUserRoles.isEmpty()) {
            defaultUserRoles = new ArrayList<String>();
            defaultUserRoles.add("Hudson Read");
        }
        return defaultUserRoles;
    }

    public Collection<String> getDefaultAdminRoles() {
        if (defaultAdminRoles.isEmpty()) {
            defaultAdminRoles = CNProjectACL.CollabNetRoles.getNames();
        }
        return defaultAdminRoles;
    }

    private void loadRoles() {
        String projectIdStr = this.getProjectId();
        if (!CommonUtil.isEmpty(projectIdStr)) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                log.warning("Cannot loadRoles, incorrect authentication type.");
                return;
            }
            if (this.createRoles()) {
                ArrayList<String> roleNames = new ArrayList<String>();
                ArrayList<String> descriptions = new ArrayList<String>();
                for (CollabNetRole role : CNProjectACL.CollabNetRoles.getAllRoles()) {
                    roleNames.add(role.getName());
                    descriptions.add(role.getDescription());
                }
                conn.addRoles(projectIdStr, roleNames, descriptions);
            }
            if (this.grantDefaultRoles()) {
                conn.grantRoles(projectIdStr, this.getDefaultUserRoles(), conn.getUsers(projectIdStr));
                conn.grantRoles(projectIdStr, this.getDefaultAdminRoles(), conn.getAdmins(projectIdStr));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(CNAuthProjectProperty.class);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Boolean createRoles = Boolean.FALSE;
            Boolean grantDefaults = Boolean.FALSE;
            if (formData.get("createRoles") != null) {
                createRoles = Boolean.TRUE;
            }
            if (formData.get("grantDefaults") != null) {
                grantDefaults = Boolean.TRUE;
            }
            String projectName = (String)formData.get("project");
            String storedProjectId = (String)formData.get("storedProjectId");
            CNAuthProjectProperty prop = new CNAuthProjectProperty(projectName, createRoles, grantDefaults, true);
            prop.loadProjectIdIfNecessary();
            if (!CommonUtil.isEmpty(prop.getProject()) && CommonUtil.isEmpty(prop.getProjectId())) {
                prop.setProjectId(storedProjectId);
            }
            return prop;
        }

        public String getDisplayName() {
            return "Associated CollabNet Project";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Hudson.getInstance().getAuthorizationStrategy() instanceof CNAuthorizationStrategy;
        }

        public FormValidation doProjectCheck(@QueryParameter String project) {
            if (CommonUtil.isEmpty(project)) {
                return FormValidation.warning((String)"If left empty, all users will be able to configure and access this build");
            }
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return FormValidation.warning((String)"Cannot check project name, improper authentication type.");
            }
            String projectId = conn.getProjectId(project);
            boolean superUser = conn.isSuperUser();
            boolean hudsonAdmin = Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER);
            if (CommonUtil.isEmpty(projectId)) {
                if (superUser) {
                    return FormValidation.error((String)"This project does not exist.");
                }
                return FormValidation.error((String)"The current user does not have access to this project.  This setting change will not be saved.");
            }
            if (superUser) {
                return FormValidation.ok();
            }
            if (!conn.isProjectAdmin(projectId)) {
                return FormValidation.warning((String)"The current user is not a project admin in the project, so he/she cannot create or grant roles.");
            }
            if (hudsonAdmin) {
                return FormValidation.ok();
            }
            CNProjectACL acl = new CNProjectACL(projectId);
            if (!acl.hasPermission(CONFIGURE_PROPERTY)) {
                CollabNetRole roleNeeded = CNProjectACL.CollabNetRoles.getGrantingRole(CONFIGURE_PROPERTY);
                return FormValidation.warning((String)("The current user does not have the '" + roleNeeded.getName() + "' role in the " + "project, which is required to configure " + "this Hudson job.  If this project is chosen," + " the current user will not have the power " + "to change the project later, unless he/she " + "is given this role."));
            }
            return FormValidation.ok();
        }

        public void doGetProjectId(StaplerRequest request, StaplerResponse response) throws IOException {
            CNConnection conn = CNConnection.getInstance();
            String project = request.getParameter("project");
            String projectId = conn == null ? "" : conn.getProjectId(project);
            response.setContentType("text/plain;charset=UTF-8");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("projectName", (Object)project);
            jsonObj.put("projectId", (Object)projectId);
            response.getWriter().print(jsonObj.toString());
        }

        public String[] getProjects() {
            Collection<Object> projects = Collections.emptyList();
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return new String[0];
            }
            projects = conn.getProjects();
            return projects.toArray(new String[0]);
        }

        public String getCollabNetUrl() {
            CNConnection conn = CNConnection.getInstance();
            return conn.getCollabNetApp().getServerUrl();
        }
    }
}

