/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNVersion
implements Comparable<CNVersion> {
    private int major = 0;
    private int minor = 0;
    private int servicePack = 0;
    private int hotfix = 0;

    public CNVersion(String versionString) {
        String[] parts = versionString.split("\\.");
        if (parts.length > 0) {
            this.major = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            this.minor = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            this.servicePack = Integer.parseInt(parts[2]);
        }
        if (parts.length > 3) {
            this.hotfix = Integer.parseInt(parts[3]);
        }
    }

    @Override
    public int compareTo(CNVersion otherVersion) {
        int LESS_THAN = -1;
        boolean EQUAL = false;
        boolean GREATER_THAN = true;
        int[] thisArray = new int[]{this.major, this.minor, this.servicePack, this.hotfix};
        int[] otherArray = new int[]{otherVersion.major, otherVersion.minor, otherVersion.servicePack, otherVersion.hotfix};
        for (int i = 0; i < thisArray.length; ++i) {
            if (thisArray[i] < otherArray[i]) {
                return -1;
            }
            if (thisArray[i] <= otherArray[i]) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.servicePack + "." + this.hotfix;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CNVersion)) {
            return false;
        }
        CNVersion other = (CNVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.servicePack == other.servicePack && this.hotfix == other.hotfix;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

