/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.browser;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Descriptor;
import hudson.plugins.collabnet.browser.OverrideAuth;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TeamForge
extends SubversionRepositoryBrowser {
    private static Logger log = Logger.getLogger("TeamForge");
    private String collabneturl;
    private String username;
    private Secret password;
    private String project;
    private String repo;
    private boolean overrideAuth;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TeamForge(String collabneturl, String username, String password, String project, String repo, OverrideAuth override_auth) {
        if (override_auth != null) {
            this.overrideAuth = true;
            this.collabneturl = override_auth.collabneturl;
            this.username = override_auth.username;
            this.password = override_auth.password;
        } else if (collabneturl == null && username == null && password == null) {
            this.overrideAuth = false;
        } else {
            this.overrideAuth = true;
            this.collabneturl = CNHudsonUtil.sanitizeCollabNetUrl(collabneturl);
            this.username = username;
            this.password = Secret.fromString((String)password);
        }
        this.project = project;
        this.repo = repo;
    }

    public TeamForge(String collabneturl, String username, String password, String project, String repo, boolean overrideAuth) {
        this.collabneturl = CNHudsonUtil.sanitizeCollabNetUrl(collabneturl);
        this.username = username;
        this.password = Secret.fromString((String)password);
        this.project = project;
        this.repo = repo;
        this.overrideAuth = overrideAuth;
    }

    public TeamForge(String project, String repo, boolean overrideAuth) {
        this(null, null, null, project, repo, overrideAuth);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean overrideAuth() {
        return this.overrideAuth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.collabneturl;
        }
        return TeamForge.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return TeamForge.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password == null ? null : this.password.toString();
        }
        return TeamForge.getTeamForgeShareDescriptor().getPassword();
    }

    public String getProject() {
        return this.project;
    }

    public String getRepo() {
        return this.repo;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        Collection<String> projects = ComboBoxUpdater.ProjectsUpdater.getProjectList(cna);
        CNHudsonUtil.logoff(cna);
        return projects.toArray(new String[0]);
    }

    public String[] getRepos() {
        String[] reposArray;
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        try {
            String projectId = cna.getProjectId(this.getProject());
            Collection<String> repos = ComboBoxUpdater.ReposUpdater.getRepoList(cna, projectId);
            reposArray = repos.toArray(new String[repos.size()]);
        }
        catch (RemoteException e) {
            reposArray = new String[]{};
        }
        CNHudsonUtil.logoff(cna);
        return reposArray;
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&view=markup");
        return new URL(link.toString());
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        int revision = path.getLogEntry().getRevision();
        int r1 = revision - 1;
        int r2 = revision;
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&r1=").append(r1).append("&r2=").append(r2);
        return new URL(link.toString());
    }

    private StringBuffer getViewerUrlWithPath(SubversionChangeLogSet.Path path) {
        String[] urlParts = this.getViewerUrl().split("\\?");
        StringBuffer viewWithPath = new StringBuffer(urlParts[0]).append(path.getValue()).append("?");
        if (urlParts.length > 1) {
            viewWithPath.append(urlParts[1]);
        }
        return viewWithPath;
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int revision = changeSet.getRevision();
        StringBuffer link = new StringBuffer(this.getViewerUrl()).append("?view=revision&system=").append(this.getSystemId()).append("&revision=").append(revision);
        return new URL(link.toString());
    }

    private String getViewerUrl() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        return CNHudsonUtil.getScmViewerUrl(cna, this.getCollabNetUrl(), this.getProject(), this.getRepo());
    }

    private String getSystemId() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        return CNHudsonUtil.getSystemId(cna, this.getProject(), this.getRepo());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(TeamForge.class);
        }

        public String getDisplayName() {
            return "Collabnet TeamForge";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/browser/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-main.html";
        }

        public boolean canInheritAuth() {
            return TeamForge.getTeamForgeShareDescriptor().useGlobal();
        }

        public FormValidation doCollabNetUrlCheck(@QueryParameter String value) {
            return CNFormFieldValidator.soapUrlCheck(value);
        }

        public FormValidation doRequiredCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredCheck(value, name);
        }

        public FormValidation doPasswordCheck(StaplerRequest req) {
            return CNFormFieldValidator.loginCheck(req);
        }

        public FormValidation doProjectCheck(StaplerRequest req) {
            return CNFormFieldValidator.projectCheck(req);
        }

        public FormValidation doRepoCheck(StaplerRequest req) {
            return CNFormFieldValidator.repoCheck(req);
        }

        public void doGetProjects(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ProjectsUpdater(req, rsp).update();
        }

        public void doGetRepos(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ReposUpdater(req, rsp).update();
        }
    }
}

