/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.pblupload;

import com.collabnet.cubit.api.CubitConnector;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.pblupload.PblUploadResultAction;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.plugins.promoted_builds.Promotion;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PblUploader
extends Notifier
implements Serializable {
    private static final String LEFT_NAV_DISPLAY_MESSAGE = "Download from CollabNet Project Build Library";
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private static final long serialVersionUID = 1L;
    private static String API_URL = "cubit_api";
    private static String API_VERSION = "1";
    private static String PBL_UPLOAD_URL = "pbl_upload";
    private String hostUrl;
    private String user;
    private String key;
    private String project;
    private String pubOrPriv = "priv";
    private String[] file_patterns;
    private String removePrefixRegex;
    private String path;
    private boolean preserveLocal = false;
    private boolean force = false;
    private String comment;
    private String description;
    private transient BuildListener listener = null;

    public PblUploader(String hostUrl, String user, String key, String project, String pubOrPriv, String[] file_patterns, String path, boolean preserveLocal, boolean force, String comment, String description, String removePrefixRegex) {
        this.hostUrl = hostUrl;
        this.user = user;
        this.key = key.trim().toLowerCase();
        this.project = project;
        this.pubOrPriv = pubOrPriv;
        this.file_patterns = file_patterns;
        this.path = path;
        this.preserveLocal = preserveLocal;
        this.force = force;
        this.comment = comment;
        this.description = description;
        this.removePrefixRegex = removePrefixRegex;
    }

    public String getHostUrl() {
        if (this.hostUrl != null) {
            return this.hostUrl;
        }
        return "";
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return "";
    }

    private String returnValueOrEmptyString(String input) {
        if (input != null) {
            return input;
        }
        return "";
    }

    public String getKey() {
        return this.returnValueOrEmptyString(this.key);
    }

    public String getProject() {
        if (this.project != null) {
            return this.project;
        }
        return "";
    }

    public String getPubOrPriv() {
        if (this.pubOrPriv != null) {
            return this.pubOrPriv;
        }
        return "";
    }

    public String[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new String[0];
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return "";
    }

    public boolean getPreserveLocal() {
        return this.preserveLocal;
    }

    public boolean getForce() {
        return this.force;
    }

    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        return "";
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "";
    }

    public String getRemovePrefixRegex() {
        if (this.removePrefixRegex != null) {
            return this.removePrefixRegex;
        }
        return "";
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            this.listener.getLogger().println(message);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean success = true;
        this.setupLogging(listener);
        this.log("");
        if (build.getResult() == Result.FAILURE) {
            this.log("Not attempting to upload files to Project Build Library because the build has failed.");
            return true;
        }
        this.log("Uploading files to Project Build Library");
        this.log(this.getRemoteURL(build));
        success = this.uploadFiles(build);
        build.addAction((Action)new PblUploadResultAction(LEFT_NAV_DISPLAY_MESSAGE, "/plugin/collabnet/images/48x48/cubit-icon.gif", "console", PblUploader.addTrailSlash(this.getRemoteURL(build)), success));
        if (!success) {
            build.setResult(build.getResult().combine(Result.UNSTABLE));
        }
        return success;
    }

    private List<String> getProcessedFilePatterns(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ArrayList<String> output = new ArrayList<String>();
        for (String uninterp_fp : this.getFilePatterns()) {
            String file_pattern = "";
            try {
                file_pattern = this.getInterpreted(build, uninterp_fp);
                if (file_pattern.equals("")) continue;
                output.add(file_pattern);
            }
            catch (IllegalArgumentException e) {
                this.log("File pattern " + uninterp_fp + " contained a bad " + "env var.  Skipping.");
            }
        }
        return output;
    }

    private boolean determineAndLogFinalState(int num_files, int failures) {
        num_files = num_files > 0 ? num_files : 0;
        int n = failures = failures > 0 ? failures : 0;
        if (num_files == 0) {
            this.log("Could not find any matching files to upload.  Please check your file patterns.");
            return false;
        }
        if (num_files == failures) {
            this.log("No files successfully uploaded.  You may want to check your configuration or the status of the Lab Management Manager.");
            return false;
        }
        if (failures == 0) {
            this.log(num_files + " files successfully uploaded!");
            return true;
        }
        this.log("Attempted to upload " + num_files + " files.");
        this.log(failures + " file uploads failed.");
        this.log(num_files - failures + " file uploads succeeded.");
        return true;
    }

    private boolean uploadFiles(AbstractBuild<?, ?> build) {
        try {
            FilePath workspace = build.getWorkspace();
            int num_files = 0;
            int failures = 0;
            this.log("");
            for (String file_pattern : this.getProcessedFilePatterns(build)) {
                this.log("Upload files matching " + file_pattern + ":");
                for (FilePath pathOfFileToUpload : workspace.list(file_pattern)) {
                    ++num_files;
                    Map<String, String> args = this.setupArgs(build, pathOfFileToUpload, workspace);
                    if (this.pblUpload(args, pathOfFileToUpload, workspace)) continue;
                    ++failures;
                }
                this.log("");
            }
            return this.determineAndLogFinalState(num_files, failures);
        }
        catch (Exception e) {
            this.log("CRITICAL ERROR: Upload of files failed due to: " + e.getMessage());
            return false;
        }
    }

    private String getLocalFilePath(FilePath workspace, FilePath uploadFilePath) {
        String path = this.getRelativePath(workspace, uploadFilePath) + uploadFilePath.getName();
        if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
        }
        return path;
    }

    private String getRemoteURL(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        return PblUploader.addTrailSlash(this.getHostUrl()) + "pbl/" + PblUploader.addTrailSlash(this.getProject()) + this.getPubOrPriv() + "/" + this.getInterpreted(build, this.getPath());
    }

    private static String addTrailSlash(String str) {
        if (str.endsWith("/")) {
            return str;
        }
        return str + "/";
    }

    private String createUploadPath(AbstractBuild<?, ?> build, FilePath workspace, FilePath uploadFilePath) throws IOException, InterruptedException {
        String fileDestinationPath = this.getInterpreted(build, this.getPath());
        if (this.getPreserveLocal()) {
            String localPath = this.getRelativePath(workspace, uploadFilePath);
            if (this.removePrefixRegex != null && !"".equals(this.removePrefixRegex)) {
                if (localPath.split(this.removePrefixRegex).length > 0 && localPath.split(this.removePrefixRegex)[0].equals("")) {
                    localPath = localPath.replaceFirst(this.removePrefixRegex, "");
                }
                if (localPath.matches(this.removePrefixRegex)) {
                    localPath = "";
                }
            }
            fileDestinationPath = PblUploader.addTrailSlash(fileDestinationPath) + localPath;
        }
        return fileDestinationPath;
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        EnvVars envVars = null;
        if (Hudson.getInstance().getPlugin("promoted-builds") != null && build.getClass().equals(Promotion.class)) {
            Promotion promotion = (Promotion)Promotion.class.cast(build);
            envVars = promotion.getTarget().getEnvironment(TaskListener.NULL);
        } else {
            envVars = build.getEnvironment(TaskListener.NULL);
        }
        try {
            return CommonUtil.getInterpreted((Map<String, String>)build.getEnvironment(TaskListener.NULL), str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    private String getRelativePath(FilePath ancestor, FilePath child) {
        try {
            String ancestor_str = ancestor.toURI().toString();
            String child_str = child.getParent().toURI().toString();
            if (child_str.startsWith(ancestor_str)) {
                return child_str.replaceFirst(ancestor_str, "");
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private Map<String, String> setupArgs(AbstractBuild<?, ?> build, FilePath uploadFilePath, FilePath workspace) throws IOException, InterruptedException {
        String comment;
        String description;
        String path;
        HashMap<String, String> args = new HashMap<String, String>();
        String md5sum = uploadFilePath.digest();
        try {
            path = this.createUploadPath(build, workspace, uploadFilePath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Setting up args failed due to bad path: " + e.getMessage());
        }
        try {
            description = this.getInterpreted(build, this.getDescription());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Setting up args failed due to bad description: " + e.getMessage());
        }
        try {
            comment = this.getInterpreted(build, this.getComment());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Setting up args failed due to bad comment: " + e.getMessage());
        }
        args.put("md5sum", md5sum);
        args.put("path", path);
        args.put("proj", this.getProject());
        args.put("type", this.getPubOrPriv());
        args.put("userid", this.getUser());
        if (this.getForce()) {
            args.put("force", "TRUE");
        }
        args.put("comment", comment);
        args.put("desc", description);
        return args;
    }

    private void logPblCallResults(CubitConnector.ResponseCodeAndBody response, Map<String, String> args, FilePath uploadFilePath, FilePath workspace) {
        String localFilePath = this.getLocalFilePath(workspace, uploadFilePath);
        String remoteURL = PblUploader.addTrailSlash(PblUploader.addTrailSlash(this.getHostUrl()) + "pbl/" + PblUploader.addTrailSlash(args.get("proj")) + args.get("type") + "/" + args.get("path")) + uploadFilePath.getName();
        String resultStr = "Upload for file " + localFilePath + " -> " + remoteURL;
        if (response.getStatus() == 200) {
            this.log(resultStr + ": OK");
        } else {
            String[] lines = response.getBody().split("\\n");
            this.log("Upload for file " + uploadFilePath.getName() + " failed: ");
            for (int i = 0; i < lines.length; ++i) {
                this.log(lines[i]);
            }
            this.log(resultStr + ": FAILED");
        }
    }

    private boolean pblUpload(final Map<String, String> args, FilePath uploadFilePath, FilePath workspace) throws IOException, InterruptedException {
        CubitConnector.ResponseCodeAndBody result = (CubitConnector.ResponseCodeAndBody)uploadFilePath.act((FilePath.FileCallable)new FilePath.FileCallable<CubitConnector.ResponseCodeAndBody>(){
            private static final long serialVersionUID = 1L;

            public CubitConnector.ResponseCodeAndBody invoke(File file, VirtualChannel channel) throws FileNotFoundException, IOException {
                CubitConnector cubitConnector = new CubitConnector(PblUploader.this.getHostUrl(), PblUploader.this.getUser(), PblUploader.this.getKey());
                return cubitConnector.callCubit(PBL_UPLOAD_URL, args, file, true);
            }
        });
        this.logPblCallResults(result, args, uploadFilePath, workspace);
        return result.getStatus() == 200;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static int unique = 0;

        public DescriptorImpl() {
            super(PblUploader.class);
        }

        public synchronized int getUniqueId() {
            int return_value = unique++;
            if (unique >= Integer.MAX_VALUE) {
                unique = 0;
            }
            return return_value;
        }

        public String getDisplayName() {
            return "Lab Management Project Build Library (PBL) Uploader";
        }

        public String getHelpUrl() {
            return "/plugin/collabnet/pblupload/";
        }

        public String getHelpFile() {
            return this.getHelpUrl() + "help-projectConfig.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public PblUploader newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject[] jpats;
            Object fileData = formData.get("files");
            if (fileData instanceof JSONArray) {
                JSONArray patData = (JSONArray)fileData;
                jpats = (JSONObject[])JSONArray.toArray((JSONArray)patData, JSONObject.class);
            } else {
                jpats = fileData instanceof JSONObject ? new JSONObject[]{(JSONObject)fileData} : new JSONObject[]{};
            }
            String[] patterns = new String[jpats.length];
            for (int i = 0; i < jpats.length; ++i) {
                patterns[i] = (String)jpats[i].get("file");
            }
            return new PblUploader((String)formData.get("host_url"), (String)formData.get("user"), (String)formData.get("key"), (String)formData.get("project"), (String)formData.get("pub_or_priv"), patterns, (String)formData.get("path"), formData.get("preserve") != null, CommonUtil.getBoolean("force", formData), (String)formData.get("comment"), (String)formData.get("description"), formData.get("preserve") != null ? (String)((JSONObject)formData.get("preserve")).get("remove_prefix_regex") : "");
        }

        public FormValidation doHostUrlCheck(@QueryParameter String value) {
            return CNFormFieldValidator.hostUrlCheck(value);
        }

        public FormValidation doRequiredCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredCheck(value, name);
        }

        public FormValidation doKeyCheck(StaplerRequest req) {
            return CNFormFieldValidator.cubitKeyCheck(req);
        }

        public FormValidation doRequiredInterpretedCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.requiredInterpretedCheck(value, name);
        }

        public FormValidation doRegexPrefixCheck(@QueryParameter String value) {
            return CNFormFieldValidator.regexCheck(value);
        }

        public FormValidation doUnRequiredInterpretedCheck(@QueryParameter String value, @QueryParameter String name) {
            return CNFormFieldValidator.unrequiredInterpretedCheck(value, name);
        }
    }
}

