/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.plugins.collabnet.auth.CNFilter;
import hudson.security.HudsonAuthenticationEntryPoint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;

public class CNAuthenticationEntryPoint
extends HudsonAuthenticationEntryPoint {
    private static Logger log = Logger.getLogger("CNAuthenticationEntryPoint");

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        String requestedWith = req.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(requestedWith)) {
            rsp.sendError(403);
        } else {
            PrintWriter out;
            String loginForm = CNFilter.getCurrentBaseUrl((HttpServletRequest)req) + req.getContextPath() + this.getLoginFormUrl();
            loginForm = MessageFormat.format(loginForm, URLEncoder.encode(req.getRequestURI(), "UTF-8"));
            req.setAttribute("loginForm", (Object)loginForm);
            rsp.setStatus(200);
            rsp.setContentType("text/html;charset=UTF-8");
            try {
                ServletOutputStream sout = rsp.getOutputStream();
                out = new PrintWriter(new OutputStreamWriter((OutputStream)sout));
            }
            catch (IllegalStateException e) {
                out = rsp.getWriter();
            }
            out.printf("<html><head><meta http-equiv='refresh' content='1;url=%1$s'/><script>window.location.replace('%1$s');</script></head><body style='background-color:white; color:white;'>Authentication required</body></html>", loginForm);
            out.flush();
        }
    }
}

