/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collection;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNRootACL
extends ACL {
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private ACL innerACL;
    private static Logger log = Logger.getLogger("CNRootACL");

    public CNRootACL(Collection<String> adminUsers, Collection<String> adminGroups, Collection<String> readUsers, Collection<String> readGroups) {
        this(adminUsers, adminGroups, readUsers, readGroups, null);
    }

    public CNRootACL(Collection<String> adminUsers, Collection<String> adminGroups, Collection<String> readUsers, Collection<String> readGroups, ACL innerACL) {
        this.adminUsers = adminUsers;
        this.adminGroups = adminGroups;
        this.readUsers = readUsers;
        this.readGroups = readGroups;
        this.innerACL = innerACL;
    }

    public boolean hasPermission(Authentication a, Permission p) {
        if (!(a instanceof CNAuthentication)) {
            return false;
        }
        String username = (String)a.getPrincipal();
        if (!username.equals("anonymous")) {
            if (p.equals(Hudson.READ)) {
                return true;
            }
            CNConnection conn = CNConnection.getInstance((Authentication)a);
            if (conn == null) {
                log.severe("Improper Authentication type used with CNAuthorizationStrategy!  CNAuthorization strategy cannot be used without CNAuthentication.  Please re-configure your Hudson instance.");
                return false;
            }
            if (conn.isSuperUser() || this.adminUsers.contains(username) || conn.isMemberOfAny(this.adminGroups)) {
                return true;
            }
            if (this.readUsers.contains(username) || conn.isMemberOfAny(this.readGroups)) {
                Permission permission = p;
                while (permission != null) {
                    if (permission.equals(Permission.READ)) {
                        return true;
                    }
                    permission = permission.impliedBy;
                }
            }
        }
        if (this.innerACL != null) {
            return this.innerACL.hasPermission(a, p);
        }
        return false;
    }
}

