/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.filerelease;

import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FileStorageApp;
import com.collabnet.ce.webservices.FrsApp;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.collabnet.filerelease.CNFileRelease;
import hudson.plugins.collabnet.filerelease.CnfrResultAction;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.plugins.promoted_builds.Promotion;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CNFileRelease
extends Publisher {
    private transient BuildListener listener = null;
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private transient CollabNetApp cna = null;
    private boolean override_auth = true;
    private String url;
    private String username;
    private String password;
    private String project;
    private String rpackage;
    private String release;
    private boolean overwrite;
    private String[] file_patterns;
    private static transient TeamForgeShare.TeamForgeShareDescriptor shareDescriptor = null;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CNFileRelease(String url, String username, String password, String project, String rpackage, String release, boolean overwrite, String[] filePatterns, boolean override_auth) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.project = project;
        this.rpackage = rpackage;
        this.release = release;
        this.overwrite = overwrite;
        this.file_patterns = filePatterns;
        this.override_auth = override_auth;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            message = "CollabNet FileRelease: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        this.log(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    public boolean overrideAuth() {
        return this.override_auth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.url;
        }
        return CNFileRelease.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return CNFileRelease.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return this.password;
        }
        return CNFileRelease.getTeamForgeShareDescriptor().getPassword();
    }

    public String getProject() {
        return this.project;
    }

    public String getPackage() {
        return this.rpackage;
    }

    public String getRelease() {
        return this.release;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public String[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new String[0];
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        if (shareDescriptor == null) {
            shareDescriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        }
        return shareDescriptor;
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        Collection projects = ComboBoxUpdater.ProjectsUpdater.getProjectList((CollabNetApp)cna);
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return projects.toArray(new String[0]);
    }

    public String[] getPackages() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)this.getProject());
        Collection packages = ComboBoxUpdater.PackagesUpdater.getPackageList((CollabNetApp)cna, (String)projectId);
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return packages.toArray(new String[0]);
    }

    public String[] getReleases() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        String packageId = this.getPackageId(this.getProjectId());
        Collection releases = ComboBoxUpdater.ReleasesUpdater.getReleaseList((CollabNetApp)cna, (String)packageId);
        CNHudsonUtil.logoff((CollabNetApp)cna);
        return releases.toArray(new String[0]);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.setupLogging(listener);
        this.cna = CNHudsonUtil.getCollabNetApp((String)this.getCollabNetUrl(), (String)this.getUsername(), (String)this.getPassword());
        if (this.cna == null) {
            this.log("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction((Action)this.createAction(0, null));
            return false;
        }
        String releaseId = this.getReleaseId();
        if (releaseId == null) {
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            this.logoff();
            build.addAction((Action)this.createAction(0, releaseId));
            return false;
        }
        int numUploaded = this.uploadFiles(build, releaseId);
        build.addAction((Action)this.createAction(numUploaded, releaseId));
        this.logoff();
        return true;
    }

    public CnfrResultAction createAction(int numUploaded, String releaseId) {
        String displaymsg = "Download from CollabNet File Release System";
        return new CnfrResultAction(displaymsg, "/plugin/collabnet/images/48x48/cn-icon.gif", "console", this.getFileReleaseUrl(releaseId), numUploaded);
    }

    private String getFileReleaseUrl(String releaseId) {
        String path = null;
        if (releaseId != null) {
            FrsApp fa = new FrsApp(this.cna);
            try {
                path = fa.getReleasePath(releaseId);
            }
            catch (RemoteException re) {
                this.log("get release path", re);
            }
        }
        if (path != null) {
            return this.getCollabNetUrl() + "/sf/frs/do/viewRelease/" + path;
        }
        return this.getCollabNetUrl();
    }

    private String getFileUrl(String path) {
        return this.getCollabNetUrl() + "/sf/frs/do/downloadFile/" + path;
    }

    public int uploadFiles(AbstractBuild<?, ?> build, String releaseId) {
        int numUploaded = 0;
        FileStorageApp sfsa = new FileStorageApp(this.cna);
        FrsApp fa = new FrsApp(this.cna);
        this.log("Uploading file to project '" + this.getProject() + "', package '" + this.getPackage() + "', release '" + this.getRelease() + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (String uninterp_fp : this.getFilePatterns()) {
            String file_pattern = "";
            try {
                file_pattern = this.getInterpreted(build, uninterp_fp);
            }
            catch (IllegalArgumentException e) {
                this.log("File pattern " + uninterp_fp + " contained a bad " + "env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals("")) continue;
            this.log("Upload files matching " + file_pattern + ":");
            for (FilePath uploadFilePath : this.getFilePaths(build, file_pattern)) {
                String fileId = null;
                try {
                    fileId = fa.findFrsFile(uploadFilePath.getName(), releaseId);
                }
                catch (RemoteException re) {
                    this.log("find file", re);
                }
                if (fileId != null) {
                    if (this.overwrite()) {
                        try {
                            fa.deleteFrsFile(fileId);
                            this.log("Deleted previously uploaded file: " + uploadFilePath.getName());
                        }
                        catch (RemoteException re) {
                            this.log("delete file", re);
                        }
                    } else {
                        this.log("File " + uploadFilePath.getName() + " already exists in the file release " + "system and overwrite is set to false.  " + "Skipping.");
                        continue;
                    }
                }
                try {
                    String path = (String)uploadFilePath.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
                    this.log("Uploaded file " + uploadFilePath.getName() + " -> " + this.getFileUrl(path));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.log("upload file", re);
                }
                catch (IOException ioe) {
                    this.log("Could not upload file due to IOException: " + ioe.getMessage());
                }
                catch (InterruptedException ie) {
                    this.log("Could not upload file due to InterruptedException: " + ie.getMessage());
                }
            }
        }
        return numUploaded;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = build.getProject().getWorkspace();
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
        }
        catch (IOException ioe) {
            this.log("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.log("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        return uploadFilePaths;
    }

    public static String getMimeType(File f) {
        return new MimetypesFileTypeMap().getContentType(f);
    }

    public void logoff() {
        if (this.cna != null) {
            CNHudsonUtil.logoff((CollabNetApp)this.cna);
            this.cna = null;
        } else {
            this.log("logoff failed. Not logged in!");
        }
    }

    public String getReleaseId() {
        String projectId = this.getProjectId();
        if (projectId == null) {
            this.log("Critical Error: projectId cannot be found for " + this.getProject() + ".  This could mean that the project " + "does not exist OR that the user logging in does not " + "have access to that project.  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        String packageId = this.getPackageId(projectId);
        if (packageId == null) {
            this.log("Critical Error: packageId cannot be found for " + this.getPackage() + ".  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        String releaseId = this.getReleaseId(packageId);
        if (releaseId == null) {
            this.log("Critical Error: releaseId cannot be found for " + this.getRelease() + ".  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        return releaseId;
    }

    public String getProjectId() {
        if (this.cna == null) {
            this.log("Cannot getProjectId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getProjectId((CollabNetApp)this.cna, (String)this.getProject());
    }

    public String getPackageId(String projectId) {
        if (this.cna == null) {
            this.log("Cannot getPackageId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getPackageId((CollabNetApp)this.cna, (String)this.getPackage(), (String)projectId);
    }

    public String getReleaseId(String packageId) {
        if (this.cna == null) {
            this.log("Cannot getReleaseId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getReleaseId((CollabNetApp)this.cna, (String)packageId, (String)this.getRelease());
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) {
        Map envVars = null;
        if (Hudson.getInstance().getPlugin("promoted-builds") != null && build.getClass().equals(Promotion.class)) {
            Promotion promotion = (Promotion)Promotion.class.cast(build);
            envVars = promotion.getTarget().getEnvVars();
        } else {
            envVars = build.getEnvVars();
        }
        try {
            return CommonUtil.getInterpreted((Map)envVars, (String)str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

