/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class CNFormFieldValidator
extends FormFieldValidator {
    private static Logger log = Logger.getLogger("CNFormFieldValidator");

    protected CNFormFieldValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response, false);
    }

    public static String checkInterpretedString(String str) {
        Pattern envPat = Pattern.compile("\\$\\{(\\w*)\\}");
        Matcher matcher = envPat.matcher(str);
        HashSet<String> envVars = new HashSet<String>(9);
        envVars.add("BUILD_NUMBER");
        envVars.add("BUILD_ID");
        envVars.add("JOB_NAME");
        envVars.add("BUILD_TAG");
        envVars.add("EXECUTOR_NUMBER");
        envVars.add("JAVA_HOME");
        envVars.add("WORKSPACE");
        envVars.add("HUDSON_URL");
        envVars.add("SVN_REVISION");
        envVars.add("CVS_BRANCH");
        String message = null;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (envVars.contains(key)) continue;
            if (message == null) {
                message = "Environmental Variables not found: " + key;
                continue;
            }
            message = message + ", " + key;
        }
        return message;
    }

    public static boolean checkUrl(String url) {
        HttpClient client = new HttpClient();
        try {
            GetMethod get = new GetMethod(url);
            int status = client.executeMethod((HttpMethod)get);
            return status == 200;
        }
        catch (IOException e) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

