/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FrsApp;
import com.collabnet.ce.webservices.TrackerApp;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CommonUtil;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class CNHudsonUtil {
    private static Logger log = Logger.getLogger("CNHudsonUtil");

    private CNHudsonUtil() {
    }

    public static CollabNetApp getCollabNetApp(String url, String username, String password) {
        if (CommonUtil.unset((String)url)) {
            return null;
        }
        try {
            return new CollabNetApp(url, username, password);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"getCollabNetApp", (RemoteException)re);
            log.log(Level.SEVERE, "getCollabNetApp failed", re);
            return null;
        }
    }

    public static CollabNetApp getCollabNetApp(StaplerRequest request) {
        String url = null;
        String username = null;
        String password = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        if (descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false")) {
            url = descriptor.getCollabNetUrl();
            username = descriptor.getUsername();
            password = descriptor.getPassword();
        } else {
            url = request.getParameter("url");
            username = request.getParameter("username");
            password = request.getParameter("password");
        }
        if (CommonUtil.unset((String)url) || CommonUtil.unset((String)username) || CommonUtil.unset((String)password)) {
            return null;
        }
        return CNHudsonUtil.getCollabNetApp((String)url, (String)username, (String)password);
    }

    public static String getUsername(StaplerRequest request) {
        String username = null;
        String override_auth = request.getParameter("override_auth");
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        username = descriptor != null && descriptor.useGlobal() && override_auth != null && override_auth.equals("false") ? descriptor.getUsername() : request.getParameter("username");
        return username;
    }

    public static void logoff(CollabNetApp cna) {
        if (cna != null) {
            try {
                cna.logoff();
            }
            catch (RemoteException re) {
                CommonUtil.logRE((Logger)log, (String)"logoff", (RemoteException)re);
            }
        }
    }

    public static String getPackageId(CollabNetApp cna, String rpackage, String projectId) {
        String packageId = null;
        if (cna != null && projectId != null) {
            FrsApp fa = new FrsApp(cna);
            try {
                packageId = fa.findPackageId(rpackage, projectId);
            }
            catch (RemoteException re) {
                CommonUtil.logRE((Logger)log, (String)"getPackageId", (RemoteException)re);
                return null;
            }
        }
        return packageId;
    }

    public static String getProjectId(CollabNetApp cna, String project) {
        String projectId = null;
        if (cna != null) {
            try {
                projectId = cna.getProjectId(project);
            }
            catch (RemoteException re) {
                CommonUtil.logRE((Logger)log, (String)"getProjectId", (RemoteException)re);
            }
        }
        return projectId;
    }

    public static String getReleaseId(CollabNetApp cna, String packageId, String release) {
        if (cna == null || packageId == null) {
            return null;
        }
        String releaseId = null;
        FrsApp fa = new FrsApp(cna);
        try {
            releaseId = fa.findReleaseIdByPackage(release, packageId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"getReleaseId", (RemoteException)re);
        }
        return releaseId;
    }

    public static String getFileId(CollabNetApp cna, String releaseId, String file) {
        if (cna == null || releaseId == null) {
            return null;
        }
        String fileId = null;
        FrsApp fa = new FrsApp(cna);
        try {
            fileId = fa.findFrsFile(file, releaseId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"getFileId", (RemoteException)re);
        }
        return fileId;
    }

    public static String getProjectReleaseId(CollabNetApp cna, String projectId, String release) {
        if (cna == null || projectId == null) {
            return null;
        }
        FrsApp fa = new FrsApp(cna);
        String releaseId = null;
        try {
            releaseId = fa.findReleaseId(release, projectId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"getProjectReleaseId", (RemoteException)re);
        }
        return releaseId;
    }

    public static String getTrackerId(CollabNetApp cna, String projectId, String trackerName) {
        if (cna == null || projectId == null) {
            return null;
        }
        TrackerApp ta = new TrackerApp(cna);
        String trackerId = null;
        try {
            trackerId = ta.getTrackerId(projectId, trackerName);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"getTrackerId", (RemoteException)re);
            return null;
        }
        return trackerId;
    }

    public static ArtifactSoapDO getTrackerArtifact(CollabNetApp cna, String project, String tracker, String issueTitle) {
        String trackerId;
        String projectId;
        ArtifactSoapDO artifact = null;
        if (cna != null && (projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project)) != null && (trackerId = CNHudsonUtil.getTrackerId((CollabNetApp)cna, (String)projectId, (String)tracker)) != null) {
            TrackerApp ta = new TrackerApp(cna);
            try {
                artifact = ta.findLastTrackerArtifact(trackerId, issueTitle);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        return artifact;
    }

    public static String getFileId(CollabNetApp cna, String project, String rpackage, String release, String file) {
        String releaseId;
        String packageId;
        String fileId = null;
        String projectId = CNHudsonUtil.getProjectId((CollabNetApp)cna, (String)project);
        if (projectId != null && (packageId = CNHudsonUtil.getPackageId((CollabNetApp)cna, (String)rpackage, (String)projectId)) != null && (releaseId = CNHudsonUtil.getReleaseId((CollabNetApp)cna, (String)packageId, (String)release)) != null) {
            fileId = CNHudsonUtil.getFileId((CollabNetApp)cna, (String)releaseId, (String)file);
        }
        return fileId;
    }

    public static boolean isUserValid(CollabNetApp cna, String username) {
        boolean valid = false;
        try {
            valid = cna.isUsernameValid(username);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"userExists", (RemoteException)re);
        }
        return valid;
    }

    public static boolean isUserMember(CollabNetApp cna, String username, String projectId) {
        boolean member = false;
        try {
            member = cna.isUserMemberOfProject(username, projectId);
        }
        catch (RemoteException re) {
            CommonUtil.logRE((Logger)log, (String)"userMember", (RemoteException)re);
        }
        return member;
    }
}

