/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import groovy.lang.Binding;
import hudson.model.Descriptor;
import hudson.plugins.collabnet.auth.CollabNetAuthManager;
import hudson.security.SecurityRealm;
import hudson.util.FormFieldValidator;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.AuthenticationManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollabNetSecurityRealm
extends SecurityRealm {
    private String collabNetUrl;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CollabNetSecurityRealm(String collabNetUrl) {
        this.collabNetUrl = collabNetUrl;
    }

    public String getCollabNetUrl() {
        return this.collabNetUrl;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new CollabNetAuthManager(this.getCollabNetUrl()));
    }

    public Filter createFilter(FilterConfig filterConfig) {
        Binding binding = new Binding();
        SecurityRealm.SecurityComponents sc = this.createSecurityComponents();
        binding.setVariable("securityComponents", (Object)sc);
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("CNSecurityFilters.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return (Filter)context.getBean("filter");
    }

    public Descriptor<SecurityRealm> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        DescriptorImpl() {
            super(CollabNetSecurityRealm.class);
        }

        public String getDisplayName() {
            return "CollabNet Security Realm";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/auth/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-securityRealm.html";
        }

        public CollabNetSecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new CollabNetSecurityRealm((String)formData.get("collabneturl"));
        }

        public void doCollabNetUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                protected void check() throws IOException, ServletException {
                    String collabNetUrl = this.request.getParameter("value");
                    if (collabNetUrl == null || collabNetUrl.equals("")) {
                        this.error("The CollabNet URL is required.");
                        return;
                    }
                    if (!DescriptorImpl.this.checkSoapUrl(collabNetUrl)) {
                        this.error("Invalid CollabNet URL.");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        private boolean checkSoapUrl(String collabNetUrl) {
            String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
            HttpClient client = new HttpClient();
            try {
                GetMethod get = new GetMethod(soapURL);
                int status = client.executeMethod((HttpMethod)get);
                return status == 200;
            }
            catch (IOException e) {
                return false;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }
}

