/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.DocumentApp;
import com.collabnet.cubit.api.CubitConnector;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class CNFormFieldValidator
extends FormFieldValidator {
    private static Logger log = Logger.getLogger("CNFormFieldValidator");

    protected CNFormFieldValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response, false);
    }

    public static String checkInterpretedString(String str) {
        Pattern envPat = Pattern.compile("\\$\\{(\\w*)\\}");
        Matcher matcher = envPat.matcher(str);
        HashSet<String> envVars = new HashSet<String>(9);
        envVars.add("BUILD_NUMBER");
        envVars.add("BUILD_ID");
        envVars.add("JOB_NAME");
        envVars.add("BUILD_TAG");
        envVars.add("EXECUTOR_NUMBER");
        envVars.add("JAVA_HOME");
        envVars.add("WORKSPACE");
        envVars.add("HUDSON_URL");
        envVars.add("SVN_REVISION");
        envVars.add("CVS_BRANCH");
        String message = null;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (envVars.contains(key)) continue;
            if (message == null) {
                message = "Environmental Variables not found: " + key;
                continue;
            }
            message = message + ", " + key;
        }
        return message;
    }

    public static boolean checkUrl(String url) {
        HttpClient client = new HttpClient();
        try {
            GetMethod get = new GetMethod(url);
            int status = client.executeMethod((HttpMethod)get);
            return status == 200;
        }
        catch (IOException e) {
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static class CubitKeyCheck
    extends CNFormFieldValidator {
        public CubitKeyCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String key = this.request.getParameter("value");
            String hostURL = this.request.getParameter("hostURL");
            String user = this.request.getParameter("user");
            if (CommonUtil.unset(key)) {
                this.error("The user API key is required.");
                return;
            }
            if (!key.matches("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}")) {
                if (key.startsWith(" ")) {
                    this.error("The key's format is invalid.  There is a leading space.");
                } else if (key.endsWith(" ")) {
                    this.error("The key's format is invalid.  There is a trailing space.");
                } else {
                    this.error("The key's format is invalid.");
                }
                return;
            }
            if (!CommonUtil.unset(hostURL) && !CommonUtil.unset(user)) {
                boolean success = false;
                try {
                    success = this.signedStatus(hostURL, user, key);
                }
                catch (IllegalArgumentException iae) {
                    success = false;
                }
                if (!success) {
                    this.warning("This host URL, username, and user API key combination cannot successfully sign in.");
                    return;
                }
            }
            this.ok();
        }

        private boolean signedStatus(String host, String user, String key) {
            String status;
            key = key.toLowerCase();
            CubitConnector conn = new CubitConnector(host, user, key);
            try {
                status = conn.callCubitApi("status_signed", new HashMap(), true);
            }
            catch (IOException e) {
                return false;
            }
            Pattern pat = Pattern.compile(".*OK.*", 32);
            return pat.matcher(status).matches();
        }
    }

    public static class RegexCheck
    extends CNFormFieldValidator {
        public RegexCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String regex = this.request.getParameter("value");
            if (!CommonUtil.unset(regex)) {
                try {
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException ex) {
                    this.error("The regular expression is not syntactically correct.");
                    return;
                }
            }
            this.ok();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupListCheck
    extends CNFormFieldValidator {
        public GroupListCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String groupStr = this.request.getParameter("groups");
            Collection<String> invalidGroups = this.getInvalidGroups(groupStr);
            if (!invalidGroups.isEmpty()) {
                this.error("The following groups do not exist: " + invalidGroups);
                return;
            }
            String userStr = this.request.getParameter("users");
            if (userStr != null && this.locksOutCurrentUser(userStr, groupStr)) {
                this.error("The authorization settings would lock the current user out of this page.  You may want to add your username to the user list.");
                return;
            }
            this.ok();
        }

        private Collection<String> getInvalidGroups(String groupStr) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return Collections.emptyList();
            }
            if (!conn.isSuperUser()) {
                return Collections.emptyList();
            }
            String[] groups = CommonUtil.splitCommaStr(groupStr);
            ArrayList<String> invalidGroups = new ArrayList<String>();
            for (String group : groups) {
                if (conn.isGroupnameValid(group)) continue;
                invalidGroups.add(group);
            }
            return invalidGroups;
        }

        private boolean locksOutCurrentUser(String userStr, String groupStr) {
            String[] users;
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return false;
            }
            if (conn.isSuperUser()) {
                return false;
            }
            String currentUser = conn.getUsername();
            for (String user : users = CommonUtil.splitCommaStr(userStr)) {
                if (!user.equals(currentUser)) continue;
                return false;
            }
            String[] groups = CommonUtil.splitCommaStr(groupStr);
            return !conn.isMemberOfAny(Arrays.asList(groups));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserListCheck
    extends CNFormFieldValidator {
        public UserListCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String userStr = this.request.getParameter("value");
            if (userStr == null || userStr.equals("")) {
                this.ok();
                return;
            }
            CNConnection conn = CNConnection.getInstance();
            if (conn == null || !conn.isSuperUser()) {
                this.warning("Cannot check if users exist unless logged in as a TeamForge site admin.  Be careful!");
                return;
            }
            Collection<String> invalidUsers = this.getInvalidUsers(userStr);
            if (!invalidUsers.isEmpty()) {
                this.error("The following users do not exist: " + invalidUsers);
                return;
            }
            this.ok();
        }

        private Collection<String> getInvalidUsers(String userStr) {
            String[] users = CommonUtil.splitCommaStr(userStr);
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return Collections.emptyList();
            }
            ArrayList<String> invalidUsers = new ArrayList<String>();
            for (String user : users) {
                if (conn.isUsernameValid(user)) continue;
                invalidUsers.add(user);
            }
            return invalidUsers;
        }
    }

    public static class AssignCheck
    extends CNFormFieldValidator {
        public AssignCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String assign = StringUtils.strip((String)this.request.getParameter("assign"));
            if (CommonUtil.unset(assign)) {
                this.ok();
                return;
            }
            String project = this.request.getParameter("project");
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            if (cna == null) {
                this.ok();
                return;
            }
            if (!CNHudsonUtil.isUserValid(cna, assign)) {
                this.warning("This user cannot be found.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            if (projectId == null) {
                this.ok();
                CNHudsonUtil.logoff(cna);
                return;
            }
            if (!CNHudsonUtil.isUserMember(cna, assign, projectId)) {
                this.warning("This user is not a member of the project.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class TrackerCheck
    extends CNFormFieldValidator {
        public TrackerCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String trackerId;
            String tracker = this.request.getParameter("tracker");
            String project = this.request.getParameter("project");
            if (CommonUtil.unset(tracker)) {
                this.error("The tracker is required.");
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            if (projectId != null && (trackerId = CNHudsonUtil.getTrackerId(cna, projectId, tracker)) == null) {
                this.warning("Tracker could not be found.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class ReleaseCheck
    extends CNFormFieldValidator {
        public ReleaseCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String releaseId;
            String projectId;
            String release = this.request.getParameter("release");
            String rpackage = this.request.getParameter("package");
            String project = this.request.getParameter("project");
            String required = this.request.getParameter("required");
            if (CommonUtil.unset(release)) {
                if (required.toLowerCase().equals("true")) {
                    this.error("The release is required.");
                } else {
                    this.ok();
                }
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String packageId = CNHudsonUtil.getPackageId(cna, rpackage, projectId = CNHudsonUtil.getProjectId(cna, project));
            if (packageId != null) {
                String releaseId2 = CNHudsonUtil.getReleaseId(cna, packageId, release);
                if (releaseId2 == null) {
                    this.warning("Release could not be found.");
                    CNHudsonUtil.logoff(cna);
                    return;
                }
            } else if (projectId != null && (releaseId = CNHudsonUtil.getProjectReleaseId(cna, projectId, release)) == null) {
                this.warning("Release could not be found.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class PackageCheck
    extends CNFormFieldValidator {
        public PackageCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String packageId;
            String rpackage = this.request.getParameter("package");
            String project = this.request.getParameter("project");
            if (CommonUtil.unset(rpackage)) {
                this.error("The package is required.");
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            if (projectId != null && (packageId = CNHudsonUtil.getPackageId(cna, rpackage, projectId)) == null) {
                this.warning("Package could not be found.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class DocumentPathCheck
    extends CNFormFieldValidator {
        public DocumentPathCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            DocumentApp da;
            String missing;
            String project = this.request.getParameter("project");
            String path = this.request.getParameter("path");
            path = path.replaceAll("/+", "/");
            if (CommonUtil.unset(path = CommonUtil.stripSlashes(path))) {
                this.error("The path is required.");
                return;
            }
            String errmsg = null;
            errmsg = DocumentPathCheck.checkInterpretedString(path);
            if (errmsg != null) {
                this.error(errmsg);
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            String projectId = CNHudsonUtil.getProjectId(cna, project);
            if (projectId != null && (missing = (da = new DocumentApp(cna)).verifyPath(projectId, path)) != null) {
                this.warning("Folder '" + missing + "' could not be " + "found in path '" + path + "'.  It (and " + "any subfolders) will " + "be created dynamically.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class ProjectCheck
    extends CNFormFieldValidator {
        public ProjectCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String username = CNHudsonUtil.getUsername(this.request);
            String project = this.request.getParameter("project");
            if (CommonUtil.unset(project)) {
                this.error("The project is required.");
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            if (cna != null) {
                if (CNHudsonUtil.getProjectId(cna, project) == null) {
                    this.warning("This project cannot be found, or user " + username + " does not have permission " + "to access it.");
                    CNHudsonUtil.logoff(cna);
                    return;
                }
                CNHudsonUtil.logoff(cna);
            }
            this.ok();
        }
    }

    public static class LoginCheck
    extends CNFormFieldValidator {
        public LoginCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String password = this.request.getParameter("password");
            if (CommonUtil.unset(password)) {
                this.error("The password is required.");
                return;
            }
            CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.request);
            if (cna == null) {
                this.warning("Login fails with this CollabNet URL/username/password combination.");
                CNHudsonUtil.logoff(cna);
                return;
            }
            CNHudsonUtil.logoff(cna);
            this.ok();
        }
    }

    public static class SoapUrlCheck
    extends CNFormFieldValidator {
        public SoapUrlCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String collabNetUrl = this.request.getParameter("value");
            if (CommonUtil.unset(collabNetUrl)) {
                this.error("The CollabNet TeamForge URL is required.");
                return;
            }
            if (!this.checkSoapUrl(collabNetUrl)) {
                this.error("Invalid CollabNet TeamForge URL.");
                return;
            }
            this.ok();
        }

        private boolean checkSoapUrl(String collabNetUrl) {
            String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
            return SoapUrlCheck.checkUrl(soapURL);
        }
    }

    public static class HostUrlCheck
    extends CNFormFieldValidator {
        public HostUrlCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String hostUrl = this.request.getParameter("value");
            if (CommonUtil.unset(hostUrl)) {
                this.error("The Host URL is required.");
                return;
            }
            Protocol acceptAllSsl = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)acceptAllSsl);
            if (!HostUrlCheck.checkUrl(hostUrl)) {
                this.error("Invalid Host URL.");
                return;
            }
            this.ok();
        }
    }

    public static class RequiredInterpretedCheck
    extends InterpretedCheck {
        public RequiredInterpretedCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response, true);
        }
    }

    public static class UnrequiredInterpretedCheck
    extends InterpretedCheck {
        public UnrequiredInterpretedCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response, false);
        }
    }

    public static class InterpretedCheck
    extends CNFormFieldValidator {
        private boolean isRequired;

        public InterpretedCheck(StaplerRequest request, StaplerResponse response, boolean isRequired) {
            super(request, response);
            this.isRequired = isRequired;
        }

        protected void check() throws IOException, ServletException {
            String str = this.request.getParameter("value");
            if (CommonUtil.unset(str)) {
                if (!this.isRequired) {
                    this.ok();
                    return;
                }
                String name = this.request.getParameter("name");
                if (CommonUtil.unset(name)) {
                    name = "above value";
                }
                this.error("The " + name + " is required.");
                return;
            }
            String errmsg = InterpretedCheck.checkInterpretedString(str);
            if (errmsg != null) {
                this.error(errmsg);
                return;
            }
            this.ok();
        }
    }

    public static class RequiredCheck
    extends CNFormFieldValidator {
        public RequiredCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        protected void check() throws IOException, ServletException {
            String value = StringUtils.strip((String)this.request.getParameter("value"));
            String name = this.request.getParameter("name");
            if (CommonUtil.unset(name)) {
                name = "above value";
            }
            if (CommonUtil.unset(value)) {
                this.error("The " + name + " is required.");
                return;
            }
            this.ok();
        }
    }
}

