/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.Descriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.collapsingconsolesections.SectionDefinition;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CollapsingSectionNote
extends ConsoleNote {
    private String sectionDisplayName;
    private String sectionStartPattern;
    private String sectionEndPattern;

    @DataBoundConstructor
    public CollapsingSectionNote(String sectionDisplayName, String sectionStartPattern, String sectionEndPattern) {
        this.sectionDisplayName = sectionDisplayName;
        this.sectionStartPattern = sectionStartPattern;
        this.sectionEndPattern = sectionEndPattern;
    }

    public String getSectionDisplayName() {
        return this.sectionDisplayName;
    }

    public String getSectionStartPattern() {
        return this.sectionStartPattern;
    }

    public String getSectionEndPattern() {
        return this.sectionEndPattern;
    }

    public SectionDefinition getDefinition() {
        return new SectionDefinition(this.sectionDisplayName, this.sectionStartPattern, this.sectionEndPattern);
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        private CollapsingSectionNote[] sections;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Console Section";
        }

        public CollapsingSectionNote[] getSections() {
            if (this.sections != null) {
                return (CollapsingSectionNote[])this.sections.clone();
            }
            return (CollapsingSectionNote[])Array.newInstance(CollapsingSectionNote.class, 0);
        }

        public SectionDefinition[] getSectionDefinitions() {
            CollapsingSectionNote[] configs = this.getSections();
            ArrayList<SectionDefinition> defs = new ArrayList<SectionDefinition>();
            for (CollapsingSectionNote config : configs) {
                defs.add(config.getDefinition());
            }
            return defs.toArray((SectionDefinition[])Array.newInstance(SectionDefinition.class, 0));
        }

        public void setSections(CollapsingSectionNote ... sections) {
            this.sections = (CollapsingSectionNote[])sections.clone();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setSections(req.bindJSONToList(this.clazz, json.get("consolesection")).toArray((CollapsingSectionNote[])Array.newInstance(this.clazz, 0)));
            this.save();
            return true;
        }
    }
}

