/*
 * The MIT License
 *
 * Copyright (c) 2010, Yahoo! Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author dty
 */
public class SectionDefinition implements Serializable {
    private String name;
    private Pattern start;
    private Pattern end;

    public SectionDefinition(String sectionName, String sectionStartPattern, String sectionEndPattern) {
        name = sectionName;
        start = Pattern.compile(sectionStartPattern);
        end = Pattern.compile(sectionEndPattern);
    }

    public String getSectionDisplayName() {
        return name;
    }

    public String getSectionDisplayName(Matcher m) {
        @SuppressWarnings("RedundantStringConstructorCall")
        String result = new String(name);

        if (m.matches()) {
            for (int i = 0; i <= m.groupCount(); i++) {
                String group = m.group(i);
                if (group != null) {
                    result = result.replaceAll("\\{" + i + "\\}", group);
                }
            }
        }

        return result;
    }

    public Pattern getSectionStartPattern() {
        return start;
    }

    public Pattern getSectionEndPattern() {
        return end;
    }
}
