/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import hudson.MarkupText;
import hudson.Util;
import hudson.console.ConsoleAnnotator;
import hudson.model.Run;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import org.jvnet.hudson.plugins.collapsingconsolesections.SectionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsingSectionAnnotator
extends ConsoleAnnotator<Object> {
    private List<SectionDefinition> sections;
    private Stack<SectionDefinition> currentSections;

    public CollapsingSectionAnnotator(SectionDefinition ... sections) {
        this.sections = Arrays.asList(sections);
        this.currentSections = new Stack();
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text) {
        SectionDefinition currentSection;
        if (!(context instanceof Run)) {
            return null;
        }
        while (!this.currentSections.empty() && (currentSection = this.currentSections.peek()).getSectionEndPattern().matcher(text.getText().trim()).matches()) {
            text.addMarkup(text.getText().length(), "</div>");
            this.currentSections.pop();
        }
        for (SectionDefinition section : this.sections) {
            Matcher m = section.getSectionStartPattern().matcher(text.getText().trim());
            if (!m.matches()) continue;
            text.addMarkup(0, "<div class=\"collapseHeader\">" + Util.escape((String)section.getSectionDisplayName(m)) + "<div class=\"collapseAction\"><p onClick=\"doToggle(this)\">Hide Details</p></div></div><div class=\"expanded\">");
            this.currentSections.push(section);
        }
        return this;
    }
}

