/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import hudson.Extension;
import hudson.Messages;
import hudson.model.Job;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.math.BigDecimal;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastSuccessAndFailedColumn
extends ListViewColumn {
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long ONE_HOUR_MS = 3600000L;
    static final long ONE_DAY_MS = 86400000L;
    private static final long ONE_MONTH_MS = 2592000000L;
    private static final long ONE_YEAR_MS = 31536000000L;

    @DataBoundConstructor
    public LastSuccessAndFailedColumn() {
    }

    public String getSuccessTimestamp(Job<?, ?> job) {
        Run run = job.getLastSuccessfulBuild();
        return this.getTimestamp(run);
    }

    public String getFailedTimestamp(Job<?, ?> job) {
        Run run = job.getLastFailedBuild();
        return this.getTimestamp(run);
    }

    protected String getTimestamp(Run<?, ?> run) {
        long now = System.currentTimeMillis();
        long timestamp = run.getTimestamp().getTimeInMillis();
        float diff = now - timestamp;
        String stime = this.getShortTimestamp(diff);
        return stime;
    }

    protected String getShortTimestamp(float time) {
        String ts;
        if (time >= 3.1536E10f) {
            float number = this.getRoundedNumber(time / 3.1536E10f);
            ts = Messages.Util_year((Object)Float.valueOf(number));
        } else if (time >= 2.592E9f) {
            float number = this.getRoundedNumber(time / 2.592E9f);
            ts = Messages.Util_month((Object)Float.valueOf(number));
        } else if (time >= 8.64E7f) {
            float number = this.getRoundedNumber(time / 8.64E7f);
            ts = Messages.Util_day((Object)Float.valueOf(number));
        } else if (time >= 3600000.0f) {
            float number = this.getRoundedNumber(time / 3600000.0f);
            ts = Messages.Util_hour((Object)Float.valueOf(number));
        } else if (time >= 60000.0f) {
            float number = this.getRoundedNumber(time / 60000.0f);
            ts = Messages.Util_minute((Object)Float.valueOf(number));
        } else if (time >= 1000.0f) {
            float number = this.getRoundedNumber(time / 1000.0f);
            ts = Messages.Util_second((Object)Float.valueOf(number));
        } else {
            ts = Messages.Util_second((Object)0);
        }
        return ts;
    }

    protected float getRoundedNumber(float number) {
        int scale = number >= 10.0f ? 0 : 1;
        return new BigDecimal(number).setScale(scale, 5).floatValue();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Latest Builds (Compact)";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

