/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractCompactColumn;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.model.Run;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildInfo
implements Comparable<BuildInfo> {
    private Run<?, ?> run;
    private String color;
    private String timeAgoString;
    private long buildTime;
    private String status;
    private String urlPart;
    private boolean isFirst;
    private boolean isLatestBuild;
    private boolean multipleBuilds;

    public BuildInfo(Run<?, ?> run, String color, String timeAgoString, long buildTime, String status, String urlPart, boolean isLatestBuild) {
        this.run = run;
        this.color = color;
        this.timeAgoString = timeAgoString;
        this.buildTime = buildTime;
        this.status = status;
        this.urlPart = urlPart;
        this.isLatestBuild = isLatestBuild;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getColor() {
        return this.color;
    }

    public String getTimeAgoString() {
        return this.timeAgoString;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLatestBuild() {
        return this.isLatestBuild;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public String getLatestBuildString(Locale locale) {
        if (this.isLatestBuild) {
            return " (" + Messages.latestBuild() + ")";
        }
        return "";
    }

    public String getStartedAgo(Locale locale) {
        return Messages._startedAgo((Object)this.timeAgoString).toString(locale);
    }

    public String getBuiltAt(Locale locale) {
        String time = AbstractCompactColumn.getBuildTimeString((long)this.buildTime, (Locale)locale);
        return Messages._builtAt((Object)time).toString(locale);
    }

    public String getLastedDuration(Locale locale) {
        return Messages._lastedDuration((Object)this.run.getDurationString()).toString(locale);
    }

    public String getFontWeight() {
        if (this.isLatestBuild && this.multipleBuilds) {
            return "bold";
        }
        return "normal";
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    public void setMultipleBuilds(boolean multipleBuilds) {
        this.multipleBuilds = multipleBuilds;
    }

    @Override
    public int compareTo(BuildInfo that) {
        return new Integer(that.run.number).compareTo(this.run.number);
    }
}

