/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.BuildInfo;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Result;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompactColumn
extends ListViewColumn {
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long ONE_HOUR_MS = 3600000L;
    static final long ONE_DAY_MS = 86400000L;
    private static final long ONE_MONTH_MS = 2592000000L;
    private static final long ONE_YEAR_MS = 31536000000L;

    public String getColumnSortData(Job<?, ?> job) {
        List<BuildInfo> builds = this.getBuilds(job);
        if (builds.isEmpty()) {
            return "0";
        }
        BuildInfo latest = builds.get(0);
        return String.valueOf(latest.getBuildTime());
    }

    public boolean isBuildsEmpty(Job<?, ?> job) {
        return this.getBuilds(job).isEmpty();
    }

    public List<BuildInfo> getBuilds(Job<?, ?> job) {
        ArrayList<BuildInfo> builds = new ArrayList<BuildInfo>();
        this.addNonNull(builds, this.getLastFailedBuild(job));
        this.addNonNull(builds, this.getLastUnstableBuild(job));
        this.addNonNull(builds, this.getLastStableBuild(job));
        if (builds.isEmpty()) {
            BuildInfo aborted = this.createBuildInfo(this.getLastAbortedBuild(job), "gray", AbstractCompactColumn.getAbortedMessage(), null, job);
            this.addNonNull(builds, aborted);
        }
        Collections.sort(builds);
        for (int i = 0; i < builds.size(); ++i) {
            BuildInfo info = (BuildInfo)builds.get(i);
            info.setFirst(i == 0);
            info.setMultipleBuilds(builds.size() > 1);
        }
        return builds;
    }

    public BuildInfo getLastFailedBuild(Job<?, ?> job) {
        boolean onlyIfLastCompleted = this.isFailedShownOnlyIfLast();
        Run lastFailedBuild = job.getLastFailedBuild();
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastFailedBuild == null) {
            return null;
        }
        if (!onlyIfLastCompleted || lastCompletedBuild.number == lastFailedBuild.number) {
            return this.createBuildInfo(job.getLastFailedBuild(), "red", AbstractCompactColumn.getFailedMessage(), "lastFailedBuild", job);
        }
        return null;
    }

    protected abstract boolean isFailedShownOnlyIfLast();

    protected abstract boolean isUnstableShownOnlyIfLast();

    public BuildInfo getLastStableBuild(Job<?, ?> job) {
        return this.createBuildInfo(job.getLastStableBuild(), "blue", AbstractCompactColumn.getStableMessage(), "lastStableBuild", job);
    }

    public BuildInfo getLastUnstableBuild(Job<?, ?> job) {
        boolean isLastCompleted;
        Run lastUnstable = null;
        for (Run latest = job.getLastBuild(); latest != null; latest = latest.getPreviousBuild()) {
            if (latest.getResult() != Result.UNSTABLE) continue;
            lastUnstable = latest;
            break;
        }
        if (lastUnstable == null) {
            return null;
        }
        Run lastCompleted = job.getLastCompletedBuild();
        boolean bl = isLastCompleted = lastCompleted != null && lastCompleted.number == lastUnstable.number;
        if (this.isUnstableShownOnlyIfLast() && !isLastCompleted) {
            return null;
        }
        String unstableColor = "orange";
        return this.createBuildInfo(lastUnstable, unstableColor, AbstractCompactColumn.getUnstableMessage(), String.valueOf(lastUnstable.number), job);
    }

    protected void addNonNull(List<BuildInfo> builds, BuildInfo info) {
        if (info != null) {
            builds.add(info);
        }
    }

    private Run<?, ?> getLastAbortedBuild(Job<?, ?> job) {
        for (Run latest = job.getLastBuild(); latest != null; latest = latest.getPreviousBuild()) {
            if (latest.getResult() != Result.ABORTED) continue;
            return latest;
        }
        return null;
    }

    private BuildInfo createBuildInfo(Run<?, ?> run, String color, String status, String urlPart, Job<?, ?> job) {
        if (run != null) {
            Run latest;
            String timeAgoString = this.getTimeAgoString(run.getTimeInMillis());
            long buildTime = run.getTime().getTime();
            if (urlPart == null) {
                urlPart = String.valueOf(run.number);
            }
            if ((latest = job.getLastCompletedBuild()) == null) {
                latest = job.getLastBuild();
            }
            BuildInfo build = new BuildInfo(run, color, timeAgoString, buildTime, status, urlPart, run.number == latest.number);
            return build;
        }
        return null;
    }

    protected String getTimeAgoString(long timestamp) {
        long now = System.currentTimeMillis();
        float diff = now - timestamp;
        String stime = this.getShortTimestamp(diff);
        return stime;
    }

    protected static String getBuildTimeString(long timeMs, Locale locale) {
        Date time = new Date(timeMs);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
        String datePattern = AbstractCompactColumn.getDatePattern(locale);
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern, locale);
        String timeString = timeFormat.format(time);
        String dateString = dateFormat.format(time);
        String dateTimeString = timeString + ", " + dateString;
        return dateTimeString;
    }

    protected static String getDatePattern(Locale locale) {
        DateFormat format = DateFormat.getDateInstance(3, locale);
        if (format instanceof SimpleDateFormat) {
            String s = ((SimpleDateFormat)format).toPattern();
            if (!s.contains("yyyy")) {
                s = s.replace("yy", "yyyy");
            }
            return s;
        }
        throw new IllegalArgumentException("Can't handle locale: " + locale);
    }

    protected String getShortTimestamp(float time) {
        String ts;
        if (time >= 3.1536E10f) {
            float number = this.getRoundedNumber(time / 3.1536E10f);
            ts = hudson.Messages.Util_year((Object)Float.valueOf(number));
        } else if (time >= 2.592E9f) {
            float number = this.getRoundedNumber(time / 2.592E9f);
            ts = hudson.Messages.Util_month((Object)Float.valueOf(number));
        } else if (time >= 8.64E7f) {
            float number = this.getRoundedNumber(time / 8.64E7f);
            ts = hudson.Messages.Util_day((Object)Float.valueOf(number));
        } else if (time >= 3600000.0f) {
            float number = this.getRoundedNumber(time / 3600000.0f);
            ts = hudson.Messages.Util_hour((Object)Float.valueOf(number));
        } else if (time >= 60000.0f) {
            float number = this.getRoundedNumber(time / 60000.0f);
            ts = hudson.Messages.Util_minute((Object)Float.valueOf(number));
        } else if (time >= 1000.0f) {
            float number = this.getRoundedNumber(time / 1000.0f);
            ts = hudson.Messages.Util_second((Object)Float.valueOf(number));
        } else {
            ts = hudson.Messages.Util_second((Object)0);
        }
        return ts;
    }

    protected float getRoundedNumber(float number) {
        int scale = number >= 10.0f ? 0 : 1;
        return new BigDecimal(number).setScale(scale, 5).floatValue();
    }

    public static final String getFailedMessage() {
        return Messages.BallColor_Failed();
    }

    public static final String getUnstableMessage() {
        return Messages.BallColor_Unstable();
    }

    public static final String getAbortedMessage() {
        return Messages.BallColor_Aborted();
    }

    public static final String getStableMessage() {
        char c;
        String message = Messages.Run_Summary_Stable();
        if (message != null && message.length() > 1 && Character.isLowerCase(c = message.charAt(0))) {
            c = Character.toUpperCase(c);
            message = c + message.substring(1);
        }
        return message;
    }

    public static abstract class AbstractCompactColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }
    }
}

