/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.jdk;

import configurationslicing.UnorderedStringSlicer;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.JDK;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public JdkSlicer() {
        super(new JdkSlicerSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdkSlicerSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DEFAULT = "(Default)";

        @Override
        public String getName() {
            return "JDK per project";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "projectjdk";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            ArrayList<String> ret = new ArrayList<String>();
            JDK jdk = item.getJDK();
            String name = jdk == null ? DEFAULT : jdk.getName();
            ret.add(name);
            return ret;
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            String val;
            if (set.size() == 0) {
                return false;
            }
            Hudson hudson = Hudson.getInstance();
            JDK jdk = null;
            Iterator<String> i$ = set.iterator();
            while (i$.hasNext() && (jdk = hudson.getJDK(val = i$.next())) == null) {
            }
            try {
                item.setJDK(jdk);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

