/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slice;
import configurationslicing.Slicer;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ConfigurationSlicing
extends ManagementLink {
    public String getDescription() {
        return "Configure a single aspect across a group of items, in contrast to the traditional configuration of all aspects of a single item";
    }

    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getUrlName() {
        return "slicing";
    }

    public String getDisplayName() {
        return "Configuration Slicing";
    }

    public ExtensionList<Slicer> getAxes() {
        return Hudson.getInstance().getExtensionList(Slicer.class);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        for (Slicer s : this.getAxes()) {
            if (!s.getUrl().equals(token)) continue;
            return new SliceExecutor(s);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SliceExecutor<T extends Slice, I> {
        Slicer<T, I> slicer;
        List<I> worklist;
        List<I> changed;
        T slice;

        public SliceExecutor(Slicer<T, I> s) {
            this.slicer = s;
            this.execute();
        }

        private void execute() {
            Slice accumulator = (Slice)this.slicer.getInitialAccumulator();
            this.worklist = this.slicer.getWorkDomain();
            for (I item : this.worklist) {
                accumulator = this.slicer.accumulate(accumulator, item);
            }
            this.slice = accumulator;
        }

        private List<I> transform(T newslice) {
            ArrayList<I> ret = new ArrayList<I>();
            this.worklist = this.slicer.getWorkDomain();
            for (I item : this.worklist) {
                if (!this.slicer.transform(newslice, item)) continue;
                ret.add(item);
            }
            return ret;
        }

        public ConfigurationSlicing getParent() {
            return ConfigurationSlicing.this;
        }

        public T getSlice() {
            return this.slice;
        }

        public List<I> getChanged() {
            return this.changed;
        }

        public List<I> getWorklist() {
            return this.worklist;
        }

        public void doSliceconfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            try {
                Slice newslice = ((Slice)this.slice).newInstance(req, req.getSubmittedForm());
                this.transform(newslice);
                this.slice = newslice;
                rsp.forward((Object)this, "changesummary", req);
            }
            catch (Descriptor.FormException e) {
                e.printStackTrace();
            }
        }
    }
}

