/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.logrotator;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogRotationSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public LogRotationSlicer(UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> spec) {
        super(spec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogRotationBuildsSliceSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getName() {
            return "Discard Old Builds Slicer - Builds";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "logrotationbuilds";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            String numToKeepStr;
            String retString = null;
            LogRotator logrotator = item.getLogRotator();
            retString = logrotator == null ? DISABLED : ((numToKeepStr = logrotator.getNumToKeepStr()).length() == 0 ? DISABLED : numToKeepStr);
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(retString);
            return ret;
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            if (set.isEmpty()) {
                return false;
            }
            LogRotator logrotator = item.getLogRotator();
            int days = -1;
            int builds = -1;
            if (logrotator != null) {
                days = logrotator.getDaysToKeep();
                builds = logrotator.getNumToKeep();
            }
            boolean disabled = false;
            for (String line : set) {
                if (line.length() == 0 || line.equals(DISABLED)) {
                    disabled = true;
                    continue;
                }
                int val = Integer.parseInt(line);
                if (val <= builds) continue;
                builds = val;
            }
            if (disabled) {
                builds = -1;
            }
            LogRotator newlogrotator = new LogRotator(days, builds);
            item.setLogRotator(newlogrotator);
            try {
                item.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogRotationDaysSliceSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getName() {
            return "Discard Old Builds Slicer - Days";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "logrotationdays";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            String daysToKeepStr;
            String retString = null;
            LogRotator logrotator = item.getLogRotator();
            retString = logrotator == null ? DISABLED : ((daysToKeepStr = logrotator.getDaysToKeepStr()).length() == 0 ? DISABLED : daysToKeepStr);
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(retString);
            return ret;
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            if (set.isEmpty()) {
                return false;
            }
            LogRotator logrotator = item.getLogRotator();
            int days = -1;
            int builds = -1;
            if (logrotator != null) {
                days = logrotator.getDaysToKeep();
                builds = logrotator.getNumToKeep();
            }
            boolean disabled = false;
            for (String line : set) {
                if (line.length() == 0 || line.equals(DISABLED)) {
                    disabled = true;
                    continue;
                }
                int val = Integer.parseInt(line);
                if (val <= days) continue;
                days = val;
            }
            if (disabled) {
                days = -1;
            }
            LogRotator newlogrotator = new LogRotator(days, builds);
            item.setLogRotator(newlogrotator);
            try {
                item.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    @Extension
    public static class Count
    extends LogRotationSlicer {
        public Count() {
            super(new LogRotationBuildsSliceSpec());
        }
    }

    @Extension
    public static class Days
    extends LogRotationSlicer {
        public Days() {
            super(new LogRotationDaysSliceSpec());
        }
    }
}

