/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.timer;

import antlr.ANTLRException;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SCMTimerSliceStringSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public SCMTimerSliceStringSlicer() {
        super(new SCMTimerSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SCMTimerSliceSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getName() {
            return "SCM Timer Trigger Slicer";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "scmtimerslicestring";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            SCMTrigger trigger = (SCMTrigger)item.getTrigger(SCMTrigger.class);
            String[] cronspec = null;
            if (trigger != null) {
                cronspec = trigger.getSpec().split("\n");
            }
            if (cronspec == null || cronspec.length == 0) {
                cronspec = new String[]{DISABLED};
            }
            return Arrays.asList(cronspec);
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            if (set.isEmpty()) {
                return false;
            }
            SCMTrigger trigger = (SCMTrigger)item.getTrigger(SCMTrigger.class);
            boolean disabled = false;
            StringBuilder triggerspec = new StringBuilder();
            for (String line : set) {
                if (line.equals(DISABLED)) {
                    disabled = true;
                    continue;
                }
                triggerspec.append(line);
            }
            try {
                SCMTrigger newtrigger = null;
                if (!disabled) {
                    newtrigger = new SCMTrigger(triggerspec.toString());
                }
                if (trigger != null) {
                    item.removeTrigger((TriggerDescriptor)trigger.getDescriptor());
                }
                if (newtrigger != null) {
                    item.addTrigger((Trigger)newtrigger);
                }
                return true;
            }
            catch (ANTLRException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

