/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slice;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.Descriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class UnorderedStringSlice<I>
extends Slice {
    private Map<String, Set<String>> nameToValues;
    private Map<String, Set<String>> valueToNames = new HashMap();
    private UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec;

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec, String mapping) {
        this(spec);
        String[] lines;
        this.nameToValues = new HashMap();
        for (String line : lines = mapping.split("\n")) {
            String[] itemNames;
            String[] bits = line.split("::", 2);
            if (bits.length < 2) continue;
            String value = bits[0].trim();
            for (String itemName : itemNames = bits[1].split(",")) {
                UnorderedStringSlice.addLine((Map)this.nameToValues, (String)itemName.trim(), (String)value.trim());
            }
        }
    }

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec) {
        this.spec = spec;
    }

    public void add(String name, Collection<String> values) {
        for (String value : values) {
            UnorderedStringSlice.addLine((Map)this.valueToNames, (String)value, (String)name);
        }
    }

    private static void addLine(Map<String, Set<String>> map, String s, String name) {
        if (!map.containsKey(s)) {
            map.put(s, new HashSet());
        }
        Set<String> list = map.get(s);
        list.add(name);
    }

    public Set<String> get(String name) {
        return (Set)this.nameToValues.get(name);
    }

    public UnorderedStringSlicer.UnorderedStringSlicerSpec<I> getSpec() {
        return this.spec;
    }

    public String getMapping() {
        StringBuffer ret = new StringBuffer();
        for (Map.Entry ent : this.valueToNames.entrySet()) {
            ret.append((String)ent.getKey());
            ret.append(" :: ");
            boolean first = true;
            for (String proj : (Set)ent.getValue()) {
                if (!first) {
                    ret.append(", ");
                }
                ret.append(proj);
                first = false;
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    public Slice newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return new UnorderedStringSlice(this.spec, formData.getString("mapping"));
    }
}

