/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.Slice;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.Descriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedStringSlice<I>
extends Slice {
    private Map<String, Set<String>> nameToValues;
    private Map<String, Set<String>> valueToNames = new HashMap<String, Set<String>>();
    private UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec;

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec, String mapping) {
        this(spec);
        String[] lines;
        this.nameToValues = new HashMap<String, Set<String>>();
        for (String line : lines = mapping.split("\n")) {
            String[] itemNames;
            String TOKEN = "::";
            int tokenIdx = line.lastIndexOf(TOKEN);
            if (tokenIdx < 0) continue;
            String value = line.substring(0, tokenIdx).trim();
            for (String itemName : itemNames = line.substring(tokenIdx + TOKEN.length()).split(",")) {
                UnorderedStringSlice.addLine(this.nameToValues, itemName.trim(), value.trim());
            }
        }
    }

    public UnorderedStringSlice(UnorderedStringSlicer.UnorderedStringSlicerSpec<I> spec) {
        this.spec = spec;
    }

    public void add(String name, Collection<String> values) {
        for (String value : values) {
            UnorderedStringSlice.addLine(this.valueToNames, value, name);
        }
    }

    private static void addLine(Map<String, Set<String>> map, String s, String name) {
        if (!map.containsKey(s)) {
            map.put(s, new HashSet());
        }
        Set<String> list = map.get(s);
        list.add(name);
    }

    public Set<String> get(String name) {
        return this.nameToValues.get(name);
    }

    public UnorderedStringSlicer.UnorderedStringSlicerSpec<I> getSpec() {
        return this.spec;
    }

    public String getMapping() {
        StringBuffer ret = new StringBuffer();
        for (Map.Entry<String, Set<String>> ent : this.valueToNames.entrySet()) {
            ret.append(ent.getKey());
            ret.append(" :: ");
            boolean first = true;
            for (String proj : ent.getValue()) {
                if (!first) {
                    ret.append(", ");
                }
                ret.append(proj);
                first = false;
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    @Override
    public Slice newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return new UnorderedStringSlice<I>(this.spec, formData.getString("mapping"));
    }
}

