/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.label;

import configurationslicing.UnorderedStringSlicer;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Label;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public LabelSlicer() {
        super(new LabelSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LabelSliceSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String ROAMING = "(Roaming)";

        @Override
        public String getName() {
            return "Tied Label Slicer";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "labelslicestring";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            Label label = item.getAssignedLabel();
            String labelName = label == null ? ROAMING : label.getName();
            return Collections.singletonList(labelName);
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            if (set.isEmpty() || set.size() > 1) {
                return false;
            }
            Label label = null;
            String labelName = set.iterator().next();
            if (ROAMING.equals(labelName)) {
                label = null;
            } else {
                label = Hudson.getInstance().getLabel(labelName);
                if (label == null) {
                    return false;
                }
            }
            try {
                item.setAssignedLabel(label);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

