/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.console;

import com.google.common.base.Preconditions;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorConsoleAnnotator<T>
extends ConsoleAnnotator<T> {
    public ConsoleAnnotator<T> annotate(Object context, MarkupText text) {
        assert (text != null);
        String str = text.getText();
        if (str.contains("BUILD SUCCESS") || str.startsWith("Finished: SUCCESS")) {
            text.addMarkup(0, text.length(), "<strong><font color='green'>", "</font></strong>");
        } else if (str.contains("BUILD FAILURE") || str.startsWith("Finished: FAILURE") || str.startsWith("Finished: ABORTED")) {
            text.addMarkup(0, text.length(), "<strong><font color='red'>", "</font></strong>");
        } else if (str.contains("ERROR") || str.contains("FAILURE") || str.contains("FAILED")) {
            text.addMarkup(0, text.length(), "<font color='red'>", "</font>");
        } else if (str.contains("WARN") || str.contains("Finished: UNSTABLE")) {
            text.addMarkup(0, text.length(), "<font color='orange'>", "</font>");
        } else if (str.contains("SUCCESS") || str.contains(".OK (")) {
            text.addMarkup(0, text.length(), "<font color='green'>", "</font>");
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={ConsoleAnnotatorFactory.class})
    public static class Factory<T>
    extends ConsoleAnnotatorFactory<T> {
        private final Provider<ColorConsoleAnnotator<T>> provider;

        @Inject
        public Factory(Provider<ColorConsoleAnnotator<T>> provider) {
            this.provider = (Provider)Preconditions.checkNotNull(provider);
        }

        public ConsoleAnnotator<T> newInstance(Object context) {
            return (ConsoleAnnotator)this.provider.get();
        }
    }
}

