/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToMasterNotifier
extends Notifier {
    private final String includes;
    private final String excludes;
    private static final Logger LOGGER = Logger.getLogger(CopyToMasterNotifier.class.getName());

    @DataBoundConstructor
    public CopyToMasterNotifier(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            try {
                FreeStyleProject project = (FreeStyleProject)build.getProject();
                FilePath projectWorkspaceOnMaster = project.getCustomWorkspace() != null && project.getCustomWorkspace().length() > 0 ? new FilePath(new File(project.getCustomWorkspace())) : new FilePath(new File(build.getProject().getRootDir(), "workspace"));
                FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
                LOGGER.finest("Copying '" + this.getIncludes() + "', excluding '" + this.getExcludes() + "' from " + projectWorkspaceOnSlave.toURI() + "' on " + Computer.currentComputer().getNode() + "to '" + projectWorkspaceOnMaster.toURI() + " on the master.");
                projectWorkspaceOnSlave.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnMaster);
            }
            catch (ClassCastException cce) {
                LOGGER.warning("This project is not a free style project: The copy back to the master will not take place.");
            }
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            LOGGER.finest("The build is taking place on the master node, no copy back to the master will take place.");
        }
        return true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }
}

