/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildWrapper;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    private final String includes;
    private final String excludes;
    private static final Logger LOGGER = Logger.getLogger(CopyToSlaveBuildWrapper.class.getName());

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            try {
                FreeStyleProject project = (FreeStyleProject)build.getProject();
                FilePath projectWorkspaceOnMaster = project.getCustomWorkspace() != null && project.getCustomWorkspace().length() > 0 ? new FilePath(new File(project.getCustomWorkspace())) : new FilePath(new File(build.getProject().getRootDir(), "workspace"));
                FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
                LOGGER.finest("Copying '" + this.getIncludes() + "', excluding '" + this.getExcludes() + "' from " + projectWorkspaceOnMaster.toURI() + " on the master " + "to '" + projectWorkspaceOnSlave.toURI() + "' on " + Computer.currentComputer().getNode() + '.');
                projectWorkspaceOnMaster.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnSlave);
            }
            catch (ClassCastException cce) {
                LOGGER.warning("This project is not a free style project: The copy to slave will not take place.");
            }
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            LOGGER.finest("The build is taking place on the master node, no copy to a slave node will take place.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }
}

