/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    private final String includes;
    private final String excludes;
    private static final Logger LOGGER = Logger.getLogger(CopyToSlaveBuildWrapper.class.getName());

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath projectWorkspaceOnMaster = CopyToSlaveUtils.getProjectWorkspaceOnMaster((AbstractBuild)build);
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            LOGGER.log(Level.FINEST, "Copying '{0}', excluding '{1}' from '{2}' on the master to '{3}' on '{4}'.", new Object[]{this.getIncludes(), this.getExcludes(), projectWorkspaceOnMaster.toURI(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode()});
            CopyToSlaveUtils.hudson5977((FilePath)projectWorkspaceOnSlave);
            projectWorkspaceOnMaster.copyRecursiveTo(this.getIncludes(), this.getExcludes(), projectWorkspaceOnSlave);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            LOGGER.finest("The build is taking place on the master node, no copy to a slave node will take place.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }
}

